<?php
session_start();
require 'db.php';

/* 🔐 Ensure user is logged in */
if (!isset($_SESSION['user_id'])) {
    die("Unauthorized access");
}

$user_id = $_SESSION['user_id'];

/* ✅ Validate amount */
if (!isset($_POST['amount']) || !is_numeric($_POST['amount'])) {
    die("Invalid amount");
}

$amount = (float) $_POST['amount'];

if ($amount < 100) {
    die("Minimum funding amount is ₦100");
}

/* 🔎 Fetch user email (recommended) */
$stmt = $pdo->prepare("SELECT email FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$email = $user['email'] ?? "customer@example.com";

/* 🔑 Flutterwave Secret Key */
$secretKey = "FLWSECK_TEST-4d02d6b21b3870d89fd29da91ba2376f-X";

/* 🔁 Unique transaction reference */
$tx_ref = "wallet_{$user_id}_" . time();

/* 🔁 Redirect after payment */
$redirect_url = "http://localhost/ship_beta/wallet-success.php";

/* 🚀 Initialize Flutterwave Payment */
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/payments",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode([
        "tx_ref" => $tx_ref,
        "amount" => $amount,
        "currency" => "NGN",
        "redirect_url" => $redirect_url,
        "payment_options" => "card,ussd,qr",
        "customer" => [
            "email" => $email,
            "name"  => "Wallet Funding"
        ],
        "meta" => [
            "user_id" => $user_id,
            "type"    => "wallet_funding"
        ],
        "customizations" => [
            "title" => "Wallet Funding",
            "description" => "Fund wallet with ₦" . number_format($amount, 2)
        ]
    ]),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curl);
$error = curl_error($curl);
curl_close($curl);

if ($error) {
    die("cURL Error: " . $error);
}

$data = json_decode($response, true);

if (isset($data['data']['link'])) {

    /* 🧠 Save transaction details for verification */
    $_SESSION['tx_ref']  = $tx_ref;
    $_SESSION['amount'] = $amount;
    $_SESSION['user_id'] = $user_id;

    header("Location: " . $data['data']['link']);
    exit;
}

echo "<h3>Failed to initiate wallet funding</h3>";
echo "<pre>";
print_r($data);
echo "</pre>";
