<?php // $user_id = $_GET['uid']; ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- BOOTSTRAP -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- CUSTOM STYLE -->
    <link rel="stylesheet" href="style1.css">

    <style>
        body {
            background: #ffffff;
            font-family: "Helvetica Neue", Arial, sans-serif;
            margin: 0;
        }

        .onboard-container {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 20px;
            text-align: center;
        }

        h2 {
            font-size: 26px;
            font-weight: 700;
            color: #002263;
            margin-bottom: 8px;
        }

        p {
            font-size: 15px;
            opacity: 0.85;
            margin-bottom: 25px;
        }

        .otp-input {
            width: 48px;
            height: 48px;
            text-align: center;
            font-size: 20px;
            font-weight: 600;
            border: 1.8px solid #007bff;
            border-radius: 8px;
        }

        .otp-input:focus {
            outline: none;
            border-color: #0056d6;
            box-shadow: 0 0 4px rgba(0, 132, 255, 0.3);
        }

        .main-btn {
            width: 100%;
            background: #ff6464;
            padding: 14px;
            border-radius: 12px;
            text-align: center;
            font-weight: 600;
            color: #fff;
            border: none;
        }

        .main-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>

<body>

<div class="onboard-container">

    <h2>Verification Code</h2>
    <p>Enter the code sent to your Email</p>

    <form action="verify_process.php" method="POST">

        <input type="hidden" name="user_id" value="<?php echo $user_id ?? ''; ?>">

        <!-- OTP INPUTS -->
        <div class="d-flex justify-content-center gap-2 mb-3">
            <?php for ($i = 1; $i <= 6; $i++): ?>
                <input type="text" maxlength="1" class="otp-input" name="d<?php echo $i; ?>">
            <?php endfor; ?>
        </div>

        <a href="#" style="color:#00a3ff; font-size:14px; display:block; margin-bottom:50px;">
            Resend OTP code
        </a>

        <button type="submit" style="background-color:#0053f1"class="main-btn">Log In</button>

    </form>

</div>


<!-- AUTO JUMP SCRIPT -->
<script>
    const inputs = document.querySelectorAll(".otp-input");

    inputs.forEach((input, index) => {
        input.addEventListener("input", () => {
            if (input.value.length === 1 && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }
        });

        input.addEventListener("keydown", (e) => {
            if (e.key === "Backspace" && index > 0 && input.value === "") {
                inputs[index - 1].focus();
            }
        });
    });
</script>

</body>
</html>
