<?php
// Include database connection
require 'db.php';

// Assume user is logged in (you'd typically get the user_id from a session)
$user_id = 1; // Example user ID, replace with actual session data

// Fetch all shipments for the user
$stmt = $pdo->prepare("
    SELECT s.tracking_code, s.status, s.created_at, r.first_name AS receiver_name
    FROM shipments s
    LEFT JOIN reciever_addresses r ON r.id = s.receiver_id
    WHERE s.user_id = ?  -- Assuming there is a user_id column in the shipments table
    ORDER BY s.created_at DESC
");
$stmt->execute([$user_id]);
$shipments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Shipments</title>

<!-- BOOTSTRAP -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
*{box-sizing:border-box;}
body {
    margin: 0;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial;
    background: #f9f9f9;
    color: #0b2c6f;
}
.header {
    display: flex;
    align-items: center;
    padding: 16px;
}
.back {
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
}
.back img { width: 18px; }
.title {
    flex: 1;
    text-align: center;
    font-size: 22px;
    font-weight: 700;
}
.container {
    padding: 20px;
}
.table {
    width: 100%;
    margin-top: 20px;
}
.table th, .table td {
    text-align: center;
}
.track-btn {
    background-color: #0b4dff;
    color: white;
    padding: 8px 15px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    text-decoration: none;
}
.track-btn:hover {
    background-color: #0056b3;
}
</style>

</head>
<body>

<div class="header">
    <div class="back" onclick="history.back()">
        <img src="assets/arrow.png" alt="Back">
    </div>
    <div class="title">My Shipments</div>
</div>

<div class="container">

    <h4>Your Shipments</h4>

    <!-- Shipment Table -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Tracking Code</th>
                <th>Status</th>
                <th>Receiver Name</th>
                <th>Date Created</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($shipments) > 0): ?>
                <?php foreach ($shipments as $shipment): ?>
                    <tr>
                        <td><?= htmlspecialchars($shipment['tracking_code']) ?></td>
                        <td><?= htmlspecialchars($shipment['status']) ?></td>
                        <td><?= htmlspecialchars($shipment['receiver_name']) ?></td>
                        <td><?= date('d M Y', strtotime($shipment['created_at'])) ?></td>
                        <td>
                            <a href="track-result.php?code=<?= urlencode($shipment['tracking_code']) ?>" class="track-btn">
                                Track 
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" class="text-center">No shipments found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

</div>

</body>
</html>
