<?php
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) die("Missing shipment ID");

/* Fetch shipment */
$stmt = $pdo->prepare("SELECT service_type, service_price, insurance_amount FROM shipments WHERE id=?");
$stmt->execute([$shipment_id]);
$ship = $stmt->fetch(PDO::FETCH_ASSOC);

/* Save */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $service_type  = $_POST['service_type'];
    $service_price = (float) $_POST['service_price'];
    $insurance     = (float) $_POST['insurance_amount'];
    $total         = $service_price + $insurance;

    $stmt = $pdo->prepare("
        UPDATE shipments 
        SET service_type=?, service_price=?, insurance_amount=?, total_amount=?
        WHERE id=?
    ");
    $stmt->execute([$service_type, $service_price, $insurance, $total, $shipment_id]);

    header("Location: review-shipment.php?shipment_id=$shipment_id");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Edit Service</title>
</head>
<body>

<form method="POST">
    <input name="service_type" value="<?= htmlspecialchars($ship['service_type']) ?>">
    <input name="service_price" type="number" value="<?= $ship['service_price'] ?>">
    <input name="insurance_amount" type="number" value="<?= $ship['insurance_amount'] ?>">
    <button type="submit">Save</button>
</form>

</body>
</html>
