<?php
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    die("Shipment ID is missing.");
}

// Get service info from query string
$service = $_GET['service'] ?? null;
$price = $_GET['price'] ?? 0;

// Fetch shipment info
$stmt = $pdo->prepare("SELECT * FROM shipments WHERE id=?");
$stmt->execute([$shipment_id]);
$shipment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$shipment) {
    die("Shipment not found.");
}

// Fetch sender info from addresses table
$stmt = $pdo->prepare("SELECT * FROM addresses WHERE id=?");
$stmt->execute([$shipment['sender_id']]);
$sender = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch receiver info from reciever_addresses table
$stmt = $pdo->prepare("SELECT * FROM reciever_addresses WHERE id=?");
$stmt->execute([$shipment['receiver_id']]);
$receiver = $stmt->fetch(PDO::FETCH_ASSOC);

// Defaults if missing
$sender_name = trim(($sender['first_name'] ?? '') . ' ' . ($sender['last_name'] ?? '')) ?: 'N/A';
$sender_email = $sender['email'] ?? 'N/A';
$sender_address = trim(($sender['address1'] ?? '') . ' ' . ($sender['address2'] ?? '')) ?: 'N/A';

$receiver_name = trim(($receiver['first_name'] ?? '') . ' ' . ($receiver['last_name'] ?? '')) ?: 'N/A';
$receiver_email = $receiver['email'] ?? 'N/A';
$receiver_address = trim(($receiver['address1'] ?? '') . ' ' . ($receiver['address2'] ?? '')) ?: 'N/A';

$insurance = $shipment['insurance_amount'] ?? 0;
$total = $price + $insurance;

// **Save service info and total into database**
$updateStmt = $pdo->prepare("UPDATE shipments SET service_type=?, service_price=?, total_amount=? WHERE id=?");
$updateStmt->execute([$service, $price, $total, $shipment_id]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Review Shipment</title>
<style>
body {
    background: #f3f3f3;
    margin: 0;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial;
    color: #333;
}
.wrap {
    max-width: 480px;
    margin: auto;
    padding: 16px;
}
h2 { color: #0b3b8f; margin-bottom: 16px; }
.box {
    background: #fff;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 16px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}
.row {
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.edit {
    background: #555;
    color: #fff;
    border-radius: 20px;
    padding: 4px 12px;
    font-size: 12px;
    cursor: pointer;
}
.small {
    font-size: 14px;
    color: #555;
    margin-top: 4px;
}
.total {
    font-size: 20px;
    font-weight: 700;
    color: #0b3b8f;
}
button {
    width: 100%;
    padding: 18px;
    background: #0b4dff;
    border: none;
    border-radius: 12px;
    font-size: 16px;
    color: #fff;
    cursor: pointer;
}
</style>
</head>
<body>

<div class="wrap">
    <h2>Review Shipment</h2>

    <div class="box">
        <div class="row"><b>Sender</b><span class="edit" onclick="location.href='sender-edit.php?shipment_id=<?= $shipment_id ?>'">Edit</span></div>
        <p class="small"><?= htmlspecialchars($sender_name) ?><br><?= htmlspecialchars($sender_email) ?><br><?= htmlspecialchars($sender_address) ?></p>
    </div>

    <div class="box">
        <div class="row"><b>Receiver</b><span class="edit" onclick="location.href='receiver-edit.php?shipment_id=<?= $shipment_id ?>'">Edit</span></div>
        <p class="small"><?= htmlspecialchars($receiver_name) ?><br><?= htmlspecialchars($receiver_email) ?><br><?= htmlspecialchars($receiver_address) ?></p>
    </div>

    <div class="box">
        <div class="row">
            <b>Service Information</b>
            <span class="edit" onclick="location.href='services.php?shipment_id=<?= $shipment_id ?>'">Edit</span>
        </div>
        <p class="small"><?= htmlspecialchars(ucfirst($service)) ?> ₦<?= number_format($price,2) ?></p>
        <p class="small">Insurance ₦<?= number_format($insurance,2) ?></p>
    </div>

    <div class="box">
        <b>Total Breakdown</b>
        <p class="small">Shipping Charge ₦<?= number_format($price,2) ?></p>
        <p class="small">Insurance ₦<?= number_format($insurance,2) ?></p>
        <div class="row">
            <span class="total">Total</span>
            <span class="total">₦<?= number_format($total,2) ?></span>
        </div>
    </div>

    <button onclick="location.href='payment.php?shipment_id=<?= $shipment_id ?>'">Continue</button>
</div>

</body>
</html>
