<?php
session_start();
require 'db.php';

// For demo, assume logged-in user ID = 1
$user_id = 1;
$success = '';
$error = '';

$sender_id = $_GET['sender_id'] ?? null;
if (!$sender_id) {
    header("Location: sender-info.php");
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name  = trim($_POST['last_name'] ?? '');
    $email      = trim($_POST['email'] ?? '');
    $address1   = trim($_POST['address1'] ?? '');
    $address2   = trim($_POST['address2'] ?? '');
    $country    = trim($_POST['country'] ?? '');
    $state      = trim($_POST['state'] ?? '');
    $city       = trim($_POST['city'] ?? '');
    $phone      = trim($_POST['phone'] ?? '');

    if (!$first_name || !$last_name || !$email || !$address1 || !$country || !$state || !$city || !$phone) {
        $error = "Please fill in all required fields.";
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO reciever_addresses 
            (user_id, sender_id, first_name, last_name, email, address1, address2, country, state, city, phone, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        $saved = $stmt->execute([
            $user_id, $sender_id, $first_name, $last_name, $email, $address1, $address2, $country, $state, $city, $phone
        ]);

        if ($saved) {
            $success = "Receiver address saved successfully!";
           // After saving receiver
$receiver_id = $pdo->lastInsertId();
// Generate unique tracking code
function generateTrackingCode($length = 10) {
    return strtoupper(bin2hex(random_bytes($length / 2))); // 10-char alphanumeric
}

$tracking_code = generateTrackingCode();

$stmt = $pdo->prepare("
    INSERT INTO shipments (user_id, sender_id, receiver_id, tracking_code)
    VALUES (?, ?, ?, ?)
");
$stmt->execute([$user_id, $sender_id, $receiver_id, $tracking_code]);

$shipment_id = $pdo->lastInsertId();

header("Location: add_items.php?shipment_id=$shipment_id");
exit;

            exit;
        } else {
            $error = "Failed to save address. Please try again.";
        }
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sender Information</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f3f3f3; font-family: "Helvetica Neue", Arial, sans-serif; margin: 0; }
        .top-bar { padding: 14px 18px; display: flex; justify-content: space-between; align-items: center; }
        .steps { font-size: 13px; color: #9aa0a6; }
        .steps span.active { color: #1e88ff; font-weight: 600; }
        .close-btn { width: 28px; height: 28px; background: #f15b5b; color: #fff; border-radius: 50%; font-size: 16px; display: flex; align-items: center; justify-content: center; cursor: pointer; }
        .content { padding: 20px; max-width: 480px; margin: auto; }
        h2 { font-size: 22px; font-weight: 700; color: #2d3cff; margin-bottom: 4px; }
        .subtext { font-size: 14px; color: #8a8a8a; margin-bottom: 22px; }
        .form-control, .form-select { background: #f3f3f3; border-radius: 14px; padding: 14px; font-size: 15px; border: 1.5px solid #ddd; }
        .form-control::placeholder { color: #9a9a9a; }
        .form-label { font-size: 13px; color: #8a8a8a; margin-bottom: 6px; }
        .phone-group { display: flex; gap: 10px; }
        .country-code { width: 90px; display: flex; align-items: center; justify-content: center; gap: 6px; background: #f3f3f3; border: 1.5px solid #ddd; border-radius: 14px; padding: 12px; font-size: 14px; }
        .flag { width: 20px; height: 14px; background: linear-gradient(to right,#1fa34a 0%,#1fa34a 33%,#fff 33%,#fff 66%,#1fa34a 66%); }
        .continue-btn { background: #f15b5b; border: none; width: 100%; padding: 16px; border-radius: 14px; font-size: 16px; font-weight: 600; color: #fff; margin-top: 30px; }
        @media (min-width: 768px) { .content { max-width: 600px; } }
        .alert { font-size: 14px; }
    </style>
</head>
<body>

<!-- TOP BAR -->
<div class="top-bar">
    <div class="steps">
        <span class="active">Sender</span> - Receiver - Items - Services - Insurance
    </div>
    <div class="close-btn" onclick="history.back()">×</div>
</div>

<!-- CONTENT -->
<div class="content">
    <h2>Reciever's Information</h2>
    <div class="subtext">Create new address</div>

    <?php if($success): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
    <?php elseif($error): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form method="POST">

        <div class="mb-3">
            <input type="text" name="first_name" class="form-control" placeholder="First Name" required>
        </div>

        <div class="mb-3">
            <input type="text" name="last_name" class="form-control" placeholder="Last Name" required>
        </div>

        <div class="mb-3">
            <input type="email" name="email" class="form-control" placeholder="Email" required>
        </div>

        <div class="mb-3">
            <input type="text" name="address1" class="form-control" placeholder="Address line" required>
        </div>

        <div class="mb-3">
            <input type="text" name="address2" class="form-control" placeholder="Address line 2 (add a landmark) - optional">
        </div>

        <div class="mb-3">
            <label class="form-label">Country</label>
            <select name="country" class="form-select" required>
                <option selected>Select</option>
                <option value="Nigeria">Nigeria</option>
                <option value="USA">USA</option>
                <option value="UK">UK</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">State</label>
            <select name="state" class="form-select" required>
                <option selected>Select</option>
                <option value="Lagos">Lagos</option>
                <option value="Abuja">Abuja</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">City</label>
            <select name="city" class="form-select" required>
                <option selected>Select</option>
                <option value="Ikeja">Ikeja</option>
                <option value="Yaba">Yaba</option>
            </select>
        </div>

        <div class="mb-4">
            <div class="phone-group">
                <div class="country-code">
                    <div class="flag"></div>
                    +234
                </div>
                <input type="tel" name="phone" class="form-control" placeholder="Phone number" required>
            </div>
        </div>

        <button type="submit" class="continue-btn">Continue</button>

    </form>
</div>

</body>
</html>
