<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- BOOTSTRAP -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: #ffffff;
            font-family: "Helvetica Neue", Arial, sans-serif;
            margin: 0;
        }

        .page-container {
            min-height: 100vh;
            padding: 25px;
        }

        .header {
            text-align: center;
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 25px;
            position: relative;
        }

        .close-btn {
            position: absolute;
            right: 0;
            top: 0;
            background: #ff6464;
            color: #fff;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            text-align: center;
            line-height: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .avatar {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            background: #4fb8a6;
            margin: 0 auto 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .avatar img {
            width: 70px;
        }

        .white-input {
            width: 100%;
            padding: 14px;
            border-radius: 12px;
            background: #fff;
            border: 1.5px solid #dcdcdc;
            margin-bottom: 14px;
            font-size: 15px;
        }

        .white-input:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 4px rgba(0, 132, 255, 0.25);
        }

        .bvn-note {
            font-size: 12px;
            color: #ff6464;
            margin-top: -8px;
            margin-bottom: 40px;
        }

        .main-btn {
            width: 100%;
            background: #0053f1;
            padding: 14px;
            border-radius: 12px;
            text-align: center;
            font-weight: 600;
            color: #fff;
            border: none;
            font-size: 16px;
        }
    </style>
</head>

<body>

<div class="page-container">

    <div class="header">
        Profile
        <div class="close-btn">×</div>
    </div>

    <!-- Avatar -->
    <div class="avatar">
        <img src="avatar.png" alt="avatar">
    </div>

    <!-- Profile Form -->
    <form style="max-width:420px; margin:auto;">

        <input type="text" class="white-input" placeholder="Full Name">

        <input type="tel" class="white-input" placeholder="Phone number">

        <input type="email" class="white-input" placeholder="Email">

        <input type="text" class="white-input" placeholder="Location">

        <input type="password" class="white-input" placeholder="BVN">

        <div class="bvn-note">
            *Verify your BVN with your Banks
        </div>

        <button type="submit" class="main-btn">Save</button>

    </form>

</div>

</body>
</html>
