<?php
session_start();
require 'db.php';

$tx_ref = $_GET['tx_ref'] ?? null;
$payment_id = $_GET['transaction_id'] ?? null;

if (!$tx_ref || !$payment_id) die("Missing payment parameters.");

// Flutterwave test secret key
$secretKey = "FLWSECK_TEST-4d02d6b21b3870d89fd29da91ba2376f-X";

// Verify payment
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/transactions/$payment_id/verify",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey",
    ],
]);
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) die("cURL Error #: $err");

$data = json_decode($response, true);

if ($data['status'] === 'success' && $data['data']['status'] === 'successful') {
    $amount = $data['data']['amount'];
    $user_id = $_SESSION['user_id'] ?? null;

    if (!$user_id) die("User session expired");

    // Update wallet
    $stmt = $pdo->prepare("SELECT * FROM wallets WHERE user_id=? LIMIT 1");
    $stmt->execute([$user_id]);
    $wallet = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($wallet) {
        $new_balance = $wallet['balance'] + $amount;
        $stmt = $pdo->prepare("UPDATE wallets SET balance=? WHERE id=?");
        $stmt->execute([$new_balance, $wallet['id']]);
        $wallet_id = $wallet['id'];
    } else {
        // Create wallet if not exists
        $stmt = $pdo->prepare("INSERT INTO wallets (user_id, type, balance, created_at) VALUES (?, 'NGN', ?, NOW())");
        $stmt->execute([$user_id, $amount]);
        $wallet_id = $pdo->lastInsertId();
    }

    // Insert wallet transaction
    $stmt = $pdo->prepare("INSERT INTO wallet_transactions (wallet_id, amount, type, reference, status, created_at) VALUES (?, ?, 'credit', ?, 'successful', NOW())");
    $stmt->execute([$wallet_id, $amount, $tx_ref]);

    // Redirect to dashboard
    header("Location: dashboard.php?payment=success");
    exit;
} else {
    die("Payment verification failed: " . $data['message']);
}
