<?php
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) die("Shipment ID missing");

// Fetch shipment total and user_id
$stmt = $pdo->prepare("SELECT user_id, service_price, insurance_amount FROM shipments WHERE id=?");
$stmt->execute([$shipment_id]);
$shipment = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$shipment) die("Shipment not found");

$total = $shipment['service_price'] + $shipment['insurance_amount'];
$user_id = $shipment['user_id'];

// Example customer email (fetch from sender or receiver)
$email = "customer@example.com";

// Flutterwave API keys
$secretKey = "FLWSECK_TEST-4d02d6b21b3870d89fd29da91ba2376f-X";

// Generate unique transaction reference
$tx_ref = "shipment_{$shipment_id}_" . time();
$redirect_url = "http://localhost/ship_beta/payment-success.php";

// Prepare payment request
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/payments",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode([
        "tx_ref" => $tx_ref,
        "amount" => $total,
        "currency" => "NGN",
        "redirect_url" => $redirect_url,
        "payment_options" => "card,ussd,qr",
        "customer" => [
            "email" => $email,
            "name" => "Customer"
        ],
        "meta" => [
            "shipment_id" => $shipment_id,
            "user_id" => $user_id
        ],
        "customizations" => [
            "title" => "Shipment Payment",
            "description" => "Payment for shipment #$shipment_id"
        ]
    ]),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    die("cURL Error #: " . $err);
}

$data = json_decode($response, true);

if (isset($data['data']['link'])) {
    // Save the tx_ref temporarily in session to verify after redirect
    session_start();
    $_SESSION['tx_ref'] = $tx_ref;
    $_SESSION['shipment_id'] = $shipment_id;
    $_SESSION['user_id'] = $user_id;

    // Redirect user to Flutterwave payment page
    header("Location: " . $data['data']['link']);
    exit;
} else {
    echo "<h3>Failed to initiate payment</h3>";
    echo "<pre>"; print_r($data); echo "</pre>";
}
