
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>

    body {
        margin: 0;
        padding: 0;
        font-family: Arial, sans-serif;
        background: #fff;
    }

    .onboard-container {
        max-width: 420px;
        margin: auto;
        padding: 20px;
        text-align: center;
    }

    .skip-row {
        text-align: right;
        margin-bottom: 10px;
    }

    .skip-text {
        font-size: 14px;
        color: #666;
        cursor: pointer;
    }

    .onboard-img {
        width: 100%;
        max-width: 260px;
        margin: 30px auto;
        display: block;
    }

    .onboard-title {
        font-size: 26px;
        font-weight: 700;
        margin-top: 20px;
    }

    .onboard-text {
        color: #666;
        margin: 10px 0 20px;
        line-height: 1.6;
        font-size: 15px;
        padding: 0 15px;
    }

    .dots {
        display: flex;
        justify-content: center;
        margin: 25px 0 35px;
        gap: 8px;
    }

    .dot {
        width: 8px;
        height: 8px;
        background: #ccc;
        border-radius: 50%;
    }

    .dot.active {
        background: #00a3ff;
        width: 20px;
        border-radius: 30px;
    }

    .main-btn {
        background: #00a3ff;
        color: white;
        padding: 12px;
        border-radius: 8px;
        font-size: 16px;
        cursor: pointer;
        text-align: center;
        width: 100%;
        max-width: 350px;
        margin: auto;
    }

    /* Mobile Optimization */
    @media (max-width: 480px) {

        .onboard-title {
            font-size: 22px;
        }

        .onboard-text {
            font-size: 14px;
        }

        .onboard-img {
            max-width: 220px;
        }

        .main-btn {
            font-size: 15px;
            padding: 10px;
        }
    }

</style>
</head>

<body>

<div class="onboard-container">

    <div class="skip-row">
        <span class="skip-text" onclick="go('login')">Skip</span>
    </div>

    <img src="onboard1.png" class="onboard-img">

    <div class="onboard-title">Easy to use</div>

    <div class="onboard-text">
        From placing orders to tracking shipments,
        every feature is just a few taps away.
    </div>

    <div class="dots">
        <span class="dot active"></span>
        <span class="dot"></span>
        <span class="dot"></span>
    </div>

    <div class="main-btn"  style="background-color:#e6534b"onclick="go('login')">Next</div>

</div>

<script>
function go(page){
    window.location.href = page + ".php";
}
</script>

</body>
</html>
