<?php
session_start();
require 'db.php';

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("
    SELECT s.id, s.created_at, s.tracking_code, t.current_status
    FROM shipments s
    LEFT JOIN tracking t ON t.shipment_id = s.id
    WHERE s.user_id = ?
    ORDER BY s.id DESC
");
$stmt->execute([$user_id]);
$shipments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>My Shipments</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: -apple-system, sans-serif;
            background: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .app {
            max-width: 480px;
            margin: auto;
            padding: 16px;
        }

        .top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 13px;
            color: #b0b0b0;
            margin-bottom: 16px;
        }

        .close {
            font-size: 24px;
            cursor: pointer;
        }

        .tracking-card {
            background: #0b3b8f;
            color: #fff;
            padding: 16px;
            border-radius: 12px;
            margin-bottom: 16px;
        }

        .tracking-code {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 8px;
        }

        .tracking-info {
            font-size: 14px;
            color: #f0f0f0;
        }

        .btn {
            display: inline-block;
            background: #0b4dff;
            color: #fff;
            padding: 8px 12px;
            border-radius: 8px;
            text-decoration: none;
            margin-top: 12px;
            font-size: 14px;
        }
    </style>
</head>
<body>
<div class="app">

    <div class="top">
        <div><a href="dashboard.php">Go Back</a></div>
        <div class="close" onclick="history.back()">×</div>
    </div>

    <h2>My Shipments</h2>

    <?php foreach ($shipments as $s): ?>
        <div class="tracking-card">
            <div class="tracking-code"style="align-item:center"><?= htmlspecialchars($s['tracking_code'] ?? 'N/A') ?></div>
            <div class="tracking-info">Date: <?= date('M d, Y', strtotime($s['created_at'])) ?></div>
            <div class="tracking-info">Status: <?= htmlspecialchars($s['current_status'] ?? 'Pending') ?></div>
            <a class="btn" href="tracking-view.php?shipment_id=<?= $s['id'] ?>">View Tracking</a>
        </div>
    <?php endforeach; ?>

</div>
</body>
</html>
