<?php
declare(strict_types=1);
session_start();

require 'db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit("Method not allowed");
}

$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

$stmt = $pdo->prepare("SELECT id, password FROM users WHERE email = ? LIMIT 1");
$stmt->execute([$email]);
$user = $stmt->fetch();

if (!$user) {
    exit("Invalid login credentials");
}

if (!password_verify($password, $user['password'])) {
    exit("Invalid login credentials");
}

/* 🔐 VERY IMPORTANT SECURITY STEP */
session_regenerate_id(true);

/* ✅ SET SESSION */
$_SESSION['user_id'] = $user['id'];

/* REDIRECT */
header("Location: dashboard.php");
exit;
