<?php
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
$tx_ref = $_GET['tx_ref'] ?? null;
if (!$shipment_id || !$tx_ref) die("Missing parameters.");

// Flutterwave Test Secret Key
$secretKey = "FLWSECK_TEST-4d02d6b21b3870d89fd29da91ba2376f-X";

// Verify the transaction
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/transactions/verify_by_reference?tx_ref=$tx_ref",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey",
        "Content-Type: application/json"
    ],
]);
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) die("cURL Error #: $err");

$data = json_decode($response, true);

// Check if payment was successful
if ($data['status'] === 'success' && $data['data']['status'] === 'successful') {
    $amount = $data['data']['amount'];
    $user_id = $data['data']['meta']['shipment_id'] ?? null;

    // Fetch the user_id from shipments table
    $stmt = $pdo->prepare("SELECT user_id FROM shipments WHERE id=?");
    $stmt->execute([$shipment_id]);
    $shipment = $stmt->fetch(PDO::FETCH_ASSOC);
    $user_id = $shipment['user_id'] ?? null;

    if ($user_id) {
        // Update wallet
        $stmt = $pdo->prepare("SELECT * FROM wallet WHERE user_id=? LIMIT 1");
        $stmt->execute([$user_id]);
        $wallet = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($wallet) {
            // Update existing balance
            $new_balance = $wallet['balance'] + $amount;
            $stmt = $pdo->prepare("UPDATE wallet SET balance=? WHERE id=?");
            $stmt->execute([$new_balance, $wallet['id']]);
            $wallet_id = $wallet['id'];
        } else {
            // Create new wallet
            $stmt = $pdo->prepare("INSERT INTO wallet (user_id, type, balance, created_at) VALUES (?, 'main', ?, NOW())");
            $stmt->execute([$user_id, $amount]);
            $wallet_id = $pdo->lastInsertId();
        }

        // Add wallet transaction
        $stmt = $pdo->prepare("INSERT INTO wallet_transaction (wallet_id, amount, type, reference, status, created_at) VALUES (?, ?, 'credit', ?, 'success', NOW())");
        $stmt->execute([$wallet_id, $amount, $tx_ref]);

        // Redirect to dashboard
        header("Location: dashboard.php?payment=success");
        exit;
    }
}

// If payment failed
header("Location: dashboard.php?payment=failed");
exit;
?>
