<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Ship Beta - Mobile</title>

<style>
:root{
  --coral: #ff6464;
}

body{
  margin:0;
  font-family: "Helvetica Neue", Arial, sans-serif;
  background:#fff;
}

/* LOGIN PAGE BACKGROUND GRADIENT */
.login-bg{
  background: linear-gradient(180deg, #04216f 0%, #0b4fb5 100%);
  min-height:100vh;
  padding:40px 20px;
  display:flex;
  flex-direction:column;
  justify-content:center;
  align-items:center;
}

/* INPUT BUTTON STYLE */
.white-btn{
  width:100%;
  background:#fff;
  padding:14px;
  border-radius:12px;
  text-align:center;
  font-weight:500;
  margin-bottom:14px;
}

.main-btn{
  width:100%;
  background:var(--coral);
  padding:14px;
  border-radius:12px;
  text-align:center;
  font-weight:600;
  color:#fff;
}

/* Divider */
.divider{
  width:100%;
  text-align:center;
  color:#fff;
  margin:14px 0;
}

.divider span{
  padding:0 10px;
}

/* ONBOARDING PAGE */
.onboard-container{
  padding:30px 20px;
  min-height:100vh;
  text-align:center;
}

.onboard-img{
  width:80%;
  max-width:260px;
  margin:0 auto 30px;
}

.onboard-title{
  font-size:24px;
  font-weight:700;
  color:#002263;
  margin-bottom:10px;
}

.onboard-text{
  font-size:15px;
  opacity:0.8;
  padding:0 20px;
}

/* Dots */
.dots{
  margin:20px 0;
}

.dot{
  display:inline-block;
  width:26px;
  height:4px;
  border-radius:20px;
  background:#d1d1d1;
  margin:0 4px;
}

.dot.active{
  background:#00a3ff;
}
</style>

<script>
function go(page){
    window.location.href = "?page=" + page;
}
</script>

</head>
<body>
<?php
$page = $_GET["page"] ?? "login";

/* ---------- LOGIN PAGE ---------- */
if($page === "login"){ ?>
<div class="login-bg">

    <h5 style="color:white; margin-bottom:25px;">Log in with</h5>

    <div class="white-btn">
        <img src="google-logo.png" width="18" style="margin-right:8px;">
        Google
    </div>

    <div class="white-btn" onclick="go('onboarding1')" style="cursor:pointer;">
        Log in with E-mail
    </div>

    <div class="divider">
        <hr style="width:32%; display:inline-block; vertical-align:middle;">
        <span>Or</span>
        <hr style="width:32%; display:inline-block; vertical-align:middle;">
    </div>

    <div class="main-btn" onclick="go('onboarding1')" style="cursor:pointer;">
        Sign up
    </div>

</div>

<?php } ?>


<?php
/* ---------- ONBOARDING 1 ---------- */
if($page === "onboarding1"){ ?>
<div class="onboard-container">

    <div style="text-align:right; margin-bottom:10px;">
        <span style="font-size:14px; cursor:pointer;" onclick="go('login')">Skip</span>
    </div>

    <img src="onboard1.png" class="onboard-img">

    <div class="onboard-title">Easy to use</div>

    <div class="onboard-text">
        From placing orders to tracking shipments,
        every feature is just a few taps away.
    </div>

    <div class="dots">
        <span class="dot active"></span>
        <span class="dot"></span>
        <span class="dot"></span>
    </div>

    <div class="main-btn" onclick="go('onboarding2')">Next</div>

</div>
<?php } ?>


<?php
/* ---------- ONBOARDING 2 ---------- */
if($page === "onboarding2"){ ?>
<div class="onboard-container">

    <div style="text-align:right; margin-bottom:10px;">
        <span style="font-size:14px; cursor:pointer;" onclick="go('login')">Skip</span>
    </div>

    <img src="onboard2.jpg" class="onboard-img">

    <div class="onboard-title">Seamless logistics<br>management</div>

    <div class="onboard-text">
        Effortlessly track, manage, and optimize your deliveries with our
        user-friendly interface and real-time updates.
    </div>

    <div class="dots">
        <span class="dot"></span>
        <span class="dot active"></span>
        <span class="dot"></span>
    </div>

    <div class="main-btn" onclick="go('onboarding3')">Next</div>

</div>
<?php } ?>


<?php
/* ---------- ONBOARDING 3 ---------- */
if($page === "onboarding3"){ ?>
<div class="onboard-container">

    <div style="text-align:right; margin-bottom:10px;">
        <span style="font-size:14px; cursor:pointer;" onclick="go('login')">Skip</span>
    </div>

    <img src="onboard3.jpg" class="onboard-img">

    <div class="onboard-title">Fast & Reliable</div>

    <div class="onboard-text">
        Enjoy quick delivery, smart logistics tracking, and real-time notifications
        for every shipment.
    </div>

    <div class="dots">
        <span class="dot"></span>
        <span class="dot"></span>
        <span class="dot active"></span>
    </div>

    <div class="main-btn" onclick="go('login')">Get Started</div>

</div>
<?php } ?>

</body>
</html>
