<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- BOOTSTRAP -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: #f2f2f2;
    font-family: "Helvetica Neue", Arial, sans-serif;
    margin: 0;
}

.page-container {
    min-height: 100vh;
    padding: 25px;
}

.header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
}

.back-btn {
    background: #00a3ff;
    color: #fff;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    font-size: 18px;
    cursor: pointer;
}

.title {
    font-size: 24px;
    font-weight: 700;
    color: #002b7f;
}

.faq-card {
    background: #e9ddff;
    padding: 18px;
    border-radius: 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 15px;
    cursor: pointer;
    margin-bottom: 10px;
}

.faq-answer {
    background: #fff;
    padding: 15px 18px;
    border-radius: 12px;
    margin-bottom: 15px;
    display: none;
    font-size: 14px;
    color: #333;
}
</style>
</head>

<body>

<div class="page-container">

    <div class="header">
        <a href="dashboard.php"><div class="back-btn">←</div></a>
        <div class="title">FAQ?</div>
    </div>

    <!-- FAQ 1 -->
    <div class="faq-card" onclick="toggleAnswer(this)">
        <span>How essential is the tracking ID?</span>
        <span>⌄</span>
    </div>
    <div class="faq-answer">
        The tracking ID is very important because it allows you to monitor your shipment in real-time and ensures it reaches the correct destination.
    </div>

    <!-- FAQ 2 -->
    <div class="faq-card" onclick="toggleAnswer(this)">
        <span>Can I change the delivery address?</span>
        <span>⌄</span>
    </div>
    <div class="faq-answer">
        Yes, you can change the delivery address before the shipment is dispatched. Contact customer support with your tracking ID to make changes.
    </div>

</div>

<script>
function toggleAnswer(card) {
    const answer = card.nextElementSibling;
    if(answer.style.display === "block") {
        answer.style.display = "none";
        card.querySelector("span:last-child").innerText = "⌄";
    } else {
        answer.style.display = "block";
        card.querySelector("span:last-child").innerText = "⌃";
    }
}
</script>

</body>
</html>
