<?php
// dashboard.php
session_start();
require 'db.php';

// Redirect to login if user is not logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Get logged-in user ID from session
$user_id = $_SESSION['user_id'];

// Get user info
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get wallet balance
$stmt = $pdo->prepare("SELECT SUM(balance) as balance FROM wallets WHERE user_id = ?");
$stmt->execute([$user_id]);
$wallet = $stmt->fetch(PDO::FETCH_ASSOC);
$wallet_balance = number_format($wallet['balance'] ?? 0, 2);

// Get shipment stats
$stmt = $pdo->prepare("
    SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN status='pending' THEN 1 ELSE 0 END) as pending,
        SUM(CASE WHEN status='delivered' THEN 1 ELSE 0 END) as delivered,
        SUM(CASE WHEN status='cancelled' THEN 1 ELSE 0 END) as cancelled
    FROM shipments
    WHERE user_id = ?
");
$stmt->execute([$user_id]);
$shipments = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <title>Dashboard</title>

    <style>
        body { background: #f2f2f2; font-family: "Helvetica Neue", Arial, sans-serif; margin: 0; }
        .app-header { background: #fff; padding: 14px 18px; display: flex; align-items: center; justify-content: space-between; border-bottom: 1px solid #eee; }
        .menu-icon { font-size: 22px; cursor: pointer; }
        .logo { height: 28px; }
        .content { padding: 20px; max-width: 1100px; margin: auto; }
        .welcome { font-weight: 700; font-size: 22px; }
        .subtitle { font-size: 14px; color: #777; margin-bottom: 16px; }
        .wallet-card { background: #fff; border-radius: 16px; padding: 18px; display: flex; align-items: center; justify-content: space-between; margin-bottom: 20px; }
        .wallet-amount { font-size: 22px; font-weight: 700; }
        .topup-btn { background: #0053f1; color: #fff; border: none; padding: 6px 14px; border-radius: 20px; font-size: 13px; cursor:pointer; }
        .stat-card { background: #fff; border-radius: 16px; padding: 18px; text-align: center; height: 100%; }
        .stat-number { font-size: 22px; font-weight: 700; }
        .stat-label { font-size: 13px; color: #777; }
        .action-card { border-radius: 18px; padding: 20px; margin-top: 18px; display: flex; align-items: center; justify-content: space-between; }
        .action-btn { background: #fff; border-radius: 12px; padding: 8px 14px; font-weight: 600; font-size: 14px; }
        .fund { background: #c9f4f8; }
        .book { background: #dff1d4; }
        .pack { background: #f6e7a1; }
        .faq  { background: #d8d9ef; }
        @media (min-width: 768px) { .welcome { font-size: 26px; } }
    </style>
</head>
<body>

<!-- HEADER -->
<div class="app-header">
    <div class="menu-icon">&#9776;</div>
    <img src="logo.png" class="logo">
</div>

<!-- CONTENT -->
<div class="content">

    <div class="welcome">Welcome <?php echo htmlspecialchars($user['email']); ?>!</div>
    <div class="subtitle">We ship <b>globally</b></div>

    <!-- Wallet -->
    <div class="wallet-card">
        <div>
            <div class="text-muted" style="font-size:13px;">Wallet Balance</div>
            <div class="wallet-amount">NGN<?php echo $wallet_balance; ?></div>
        </div>
        
           <a href="tracking-view.php"class="topup-btn" >Track Order</a>
    </div>

    <!-- Stats -->
    <div class="row g-3">
        <div class="col-6 col-md-3">
            <div class="stat-card">
                <div class="stat-number"><?php echo $shipments['total'] ?? 0; ?></div>
                <div class="stat-label">All Shipments</div>
            </div>
        </div>
        <div class="col-6 col-md-3">
            <div class="stat-card">
                <div class="stat-number"><?php echo $shipments['pending'] ?? 0; ?></div>
                <div class="stat-label">Pending Shipments</div>
            </div>
        </div>
        <div class="col-6 col-md-3">
            <div class="stat-card">
                <div class="stat-number"><?php echo $shipments['delivered'] ?? 0; ?></div>
                <div class="stat-label">Delivered Shipments</div>
            </div>
        </div>
        <div class="col-6 col-md-3">
            <div class="stat-card">
                <div class="stat-number"><?php echo $shipments['cancelled'] ?? 0; ?></div>
                <div class="stat-label">Cancelled Shipments</div>
            </div>
        </div>
    </div>

    <!-- Actions -->
     <a href="fund-wallet.php" style="text-decoration:none; color:inherit; display:block;">
    
    <div class="action-card fund">

        <div class="action-btn">Fund Wallet</div>
        <img src="assets/vector.png" style="height:60px;">
    </div>

    <a href="sender-info.php" style="text-decoration:none; color:inherit; display:block;">
    <div class="action-card book">
        <div class="action-btn">Book Shipments</div>
        <img src="assets/vector2.png" style="height:60px;">
    </div>
</a>

<a href="packaging.php" style="text-decoration:none; color:inherit; display:block;">
    <div class="action-card pack">
        <div class="action-btn">Purchase Packaging</div>
        <img src="assets/vector3.png" style="height:60px;">
    </div>
</a>
<a href="faq.php" style="text-decoration:none; color:inherit; display:block;">
    <div class="action-card faq">
        <div class="action-btn">FAQ</div>
        <img src="assets/vector4.png" style="height:60px;">
    </div>

</div>

<script>
function topUp() {
    let amount = prompt("Enter topup amount:");
    if (!amount) return;

    fetch('topup.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: "amount=" + encodeURIComponent(amount)
    })
    .then(res => res.json())
    .then(resp => {
        alert(resp.message);
        if(resp.success) location.reload();
    });
}
</script>

</body>
</html>
