<?php
require 'db.php';
$shipment_id = $_GET['shipment_id'];

$stmt = $pdo->prepare("SELECT service_price, insurance_amount FROM shipments WHERE id=?");
$stmt->execute([$shipment_id]);
$ship = $stmt->fetch(PDO::FETCH_ASSOC);
$total = $ship['service_price'] + $ship['insurance_amount'];
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Card Payment</title>
<style>
body{
    background:#ededed;
    font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto;
}
.wrap{max-width:420px;margin:auto;padding:20px;}
input{
    width:100%;
    padding:14px;
    border-radius:12px;
    border:1px solid #ccc;
    margin-bottom:12px;
    font-size:16px;
}
.row{display:flex;gap:10px;}
button{
    background:#7ee293;
    width:100%;
    padding:18px;
    border:none;
    border-radius:14px;
    font-size:16px;
}
.logos{text-align:center;margin-bottom:20px;}
</style>
</head>
<body>

<div class="wrap">
    <div class="logos">
        <img src="visa.png" height="30">
        <img src="mastercard.png" height="30">
    </div>

    <form method="POST" action="process-payment.php">
        <input type="hidden" name="shipment_id" value="<?= $shipment_id ?>">

        <input name="card_number" placeholder="CARD NUMBER">
        <div class="row">
            <input name="expiry" placeholder="MM / YY">
            <input name="cvv" placeholder="CVV">
        </div>

        <button>Pay <?= number_format($total,2) ?></button>
    </form>
</div>

</body>
</html>
