<?php
session_start();
require 'db.php';

/* 🔐 Admin protection */
if (!isset($_SESSION['admin'])) {
    die("Access denied");
}

$admin_id = $_SESSION['admin'];

/* ✅ Validate shipment ID */
if (!isset($_GET['id']) || !ctype_digit($_GET['id'])) {
    die("Invalid shipment reference");
}

$shipment_id = (int) $_GET['id'];
$success     = false;

/* ✅ Handle update */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Sanitize input
    $status   = trim($_POST['status'] ?? '');
    $location = trim($_POST['location'] ?? '');
    $eta      = trim($_POST['eta'] ?? '');
    $days     = trim($_POST['days'] ?? 0);

    // Check if tracking exists for this shipment
    $check = $pdo->prepare("SELECT id FROM tracking WHERE shipment_id = ?");
    $check->execute([$shipment_id]);
    $exists = $check->fetchColumn();

    if ($exists) {
        // Update existing tracking
        $stmt = $pdo->prepare("
            UPDATE tracking SET 
                current_status   = ?,
                current_location = ?,
                eta_time         = ?,
                days_left        = ?,
                admin_id         = ?,
                updated_at       = NOW()
            WHERE shipment_id = ?
        ");
        $stmt->execute([
            $status,
            $location,
            $eta,
            $days,
            $admin_id,
            $shipment_id
        ]);
    } else {
        // Insert new tracking row
        $stmt = $pdo->prepare("
            INSERT INTO tracking 
            (shipment_id, current_status, current_location, eta_time, days_left, admin_id, updated_at)
            VALUES (?, ?, ?, ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $shipment_id,
            $status,
            $location,
            $eta,
            $days,
            $admin_id
        ]);
    }

    $success = true;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Update Shipment</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f4f6f9; }
.card { border-radius: 16px; }
.form-control { border-radius: 12px; padding: 12px; }
.btn-primary { border-radius: 12px; padding: 12px; }
</style>
</head>
<body>

<div class="container mt-5" style="max-width:520px">
    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="mb-3">Update Shipment Tracking</h5>

            <?php if ($success): ?>
                <div class="alert alert-success">
                    Tracking saved successfully.
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Current Status</label>
                    <input type="text" name="status" class="form-control" placeholder="Delivering / In Transit" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Current Location</label>
                    <input type="text" name="location" class="form-control" placeholder="Lagos Warehouse" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">ETA Time</label>
                    <input type="text" name="eta" class="form-control" placeholder="10:30 AM">
                </div>
                <div class="mb-4">
                    <label class="form-label">Days Left</label>
                    <input type="number" name="days" class="form-control" placeholder="3">
                </div>
                <button class="btn btn-primary w-100">Save Tracking</button>
            </form>

            <a href="admin-shipments.php" class="btn btn-link mt-3 w-100">← Back to Shipments</a>

        </div>
    </div>
</div>

</body>
</html>
