<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    die("Access denied");
}

$stmt = $pdo->query("
    SELECT 
        s.id,
        s.tracking_code,
        s.status,
        s.created_at,

        t.current_status,

        -- Sender
        a.city  AS sender_city,
        a.state AS sender_state,
        a.country AS sender_country,

        -- Receiver
        r.first_name AS receiver_name,
        r.city  AS receiver_city,
        r.state AS receiver_state,
        r.country AS receiver_country

    FROM shipments s

    LEFT JOIN tracking t 
        ON t.shipment_id = s.id

    LEFT JOIN addresses a 
        ON a.id = s.sender_id

    LEFT JOIN reciever_addresses r 
        ON r.id = s.receiver_id

    ORDER BY s.created_at DESC
");

$shipments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin – Shipments</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background:#f4f6f9;
}
.card {
    border-radius: 16px;
}
.table thead th {
    font-size: 13px;
    text-transform: uppercase;
    color: #6c757d;
}
.badge-status {
    padding: 6px 10px;
    border-radius: 12px;
    font-size: 12px;
}
</style>
</head>

<body>

<div class="container mt-4">

    <div class="card shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">All Shipments</h5>
                <span class="text-muted small"><?= count($shipments) ?> total</span>
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>Tracking Code</th>
                            <th>Sender</th>
                            <th>Receiver</th>
                            <th>Status</th>
                            <th>Tracking</th>
                            <th>Date</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>

                    <?php if (!$shipments): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">
                                No shipments found
                            </td>
                        </tr>
                    <?php endif; ?>

                    <?php foreach ($shipments as $s): ?>
                        <tr>
                            <td><strong><?= htmlspecialchars($s['tracking_code']) ?></strong></td>

                            <td class="small">
                                <?= htmlspecialchars($s['sender_city']) ?>,
                                <?= htmlspecialchars($s['sender_state']) ?><br>
                                <span class="text-muted"><?= htmlspecialchars($s['sender_country']) ?></span>
                            </td>

                            <td class="small">
                                <strong><?= htmlspecialchars($s['receiver_name']) ?></strong><br>
                                <?= htmlspecialchars($s['receiver_city']) ?>,
                                <?= htmlspecialchars($s['receiver_state']) ?><br>
                                <span class="text-muted"><?= htmlspecialchars($s['receiver_country']) ?></span>
                            </td>

                            <td>
                                <span class="badge bg-secondary badge-status">
                                    <?= htmlspecialchars($s['status']) ?>
                                </span>
                            </td>

                            <td>
                                <span class="badge bg-info badge-status">
                                    <?= htmlspecialchars($s['current_status'] ?? 'Not started') ?>
                                </span>
                            </td>

                            <td class="small text-muted">
                                <?= date('d M Y', strtotime($s['created_at'])) ?>
                            </td>

                            <td>
                                <a href="admin-update.php?id=<?= $s['id'] ?>"
                                   class="btn btn-sm btn-primary">
                                    Update
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>
                </table>
            </div>

        </div>
    </div>

</div>

</body>
</html>
