<?php
session_start();
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    header("Location: sender-info.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Items</title>
    <style>
        body {
            background: #f3f3f3;
            font-family: "Helvetica Neue", Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        /* TOP BAR */
        .top-bar {
            padding: 14px 18px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        .steps {
            font-size: 13px;
            color: #9aa0a6;
        }
        .steps span.active {
            color: #1e88ff;
            font-weight: 600;
        }
        .close-btn {
            width: 28px;
            height: 28px;
            background: #f15b5b;
            color: #fff;
            border-radius: 50%;
            font-size: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
        }

        /* CONTAINER */
        .container {
            max-width: 480px;
            width: 90%;
            margin: 40px auto;
            padding: 20px;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        h2 {
            color: #2d3cff;
            font-size: 24px;
            margin-bottom: 10px;
            text-align: center;
        }

        p {
            text-align: center;
            color: #555;
            font-size: 16px;
            margin-bottom: 40px;
        }

        .add-btn {
            display: flex;
            justify-content: center;
            align-items: center;
            background: #8ef3de;
            padding: 18px;
            border-radius: 16px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            color: #000;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        .add-btn:hover {
            transform: scale(1.03);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }

        @media (max-width: 400px) {
            h2 { font-size: 20px; }
            p { font-size: 14px; }
            .add-btn { font-size: 16px; padding: 16px; }
        }
    </style>
</head>
<body>

<!-- TOP BAR -->
<div class="top-bar">
    <div class="steps">
        Sender - Receiver -<span class="active"> Items</span> - Services - Insurance
    </div>
    <div class="close-btn" onclick="history.back()">×</div>
</div>

<!-- CONTENT -->
<div class="container">
    <h2>Add Items</h2>
    <p>Input your shipment</p>

    <a href="item_description.php?shipment_id=<?php echo $shipment_id; ?>" class="add-btn">➕ Add Item</a>
</div>

</body>
</html>
