<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    die("Please login");
}

$user_id = $_SESSION['user_id'];
$amount  = floatval($_POST['amount'] ?? 0);

if ($amount < 100) {
    die("Minimum funding is ₦100");
}

/* Fetch user email */
$stmt = $pdo->prepare("SELECT email FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$email = $stmt->fetchColumn();

if (!$email) {
    die("User email not found");
}

/* Flutterwave secret key */
$secretKey = "FLWSECK_TEST-4d02d6b21b3870d89fd29da91ba2376f-X";

/* Transaction reference */
$tx_ref = "wallet_{$user_id}_" . time();

/* IMPORTANT: must be public (NOT localhost) */
$redirect_url = "https://honeywey.org/ship_beta/wallet-callback.php";

/* Prepare payment */
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/payments",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => json_encode([
        "tx_ref" => $tx_ref,
        "amount" => $amount,
        "currency" => "NGN",
        "redirect_url" => $redirect_url,
        "payment_options" => "card,ussd,banktransfer",
        "customer" => [
            "email" => $email,
            "name" => "Wallet User"
        ],
        "meta" => [
            "user_id" => $user_id
        ],
        "customizations" => [
            "title" => "Wallet Funding",
            "description" => "Fund wallet"
        ]
    ]),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    die("cURL Error #: " . $err);
}

$data = json_decode($response, true);

if (isset($data['data']['link'])) {

    /* Save reference in session (same as your shipment code) */
    $_SESSION['tx_ref']  = $tx_ref;
    $_SESSION['amount']  = $amount;

    header("Location: " . $data['data']['link']);
    exit;

} else {
    echo "<h3>Failed to initiate wallet funding</h3>";
    echo "<pre>"; print_r($data); echo "</pre>";
}
