<?php
session_start();
require 'db.php';

if (!isset($_GET['transaction_id'])) {
    die("Transaction ID missing");
}

$transaction_id = $_GET['transaction_id'];
$secretKey = "FLWSECK_TEST-4d02d6b21b3870d89fd29da91ba2376f-X";

/* Verify payment */
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/transactions/$transaction_id/verify",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secretKey"
    ],
]);

$response = curl_exec($curl);
curl_close($curl);

$result = json_decode($response, true);

if (
    $result['status'] !== 'success' ||
    $result['data']['status'] !== 'successful'
) {
    header("Location: dashboard.php?wallet=failed");
    exit;
}

$user_id = $result['data']['meta']['user_id'];
$amount  = $result['data']['amount'];

/* Ensure wallet exists */
$stmt = $pdo->prepare("SELECT id FROM wallets WHERE user_id = ?");
$stmt->execute([$user_id]);

if ($stmt->rowCount() === 0) {
    $stmt = $pdo->prepare("INSERT INTO wallets (user_id, balance) VALUES (?, 0)");
    $stmt->execute([$user_id]);
}

/* Credit wallet */
$stmt = $pdo->prepare("UPDATE wallets SET balance = balance + ? WHERE user_id = ?");
$stmt->execute([$amount, $user_id]);

/* Update session balance */
$stmt = $pdo->prepare("SELECT balance FROM wallets WHERE user_id = ?");
$stmt->execute([$user_id]);
$_SESSION['wallet_balance'] = $stmt->fetchColumn();

/* Redirect */
header("Location: dashboard.php?wallet_success=1");
exit;
