<?php
include 'db.php';

$user_id = $_POST['user_id'] ?? $_GET['uid'] ?? null;

if (!$user_id) {
    die("User ID missing");
}

$otp_input = trim(
    ($_POST['d1'] ?? '') .
    ($_POST['d2'] ?? '') .
    ($_POST['d3'] ?? '') .
    ($_POST['d4'] ?? '') .
    ($_POST['d5'] ?? '') .
    ($_POST['d6'] ?? '')
);

$stmt = $pdo->prepare("
    SELECT * FROM otp_codes 
    WHERE user_id = ? 
    ORDER BY id DESC 
    LIMIT 1
");
$stmt->execute([$user_id]);
$otp = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$otp) {
    die("OTP not found!");
}

if ((string)$otp_input !== (string)$otp['otp_code']) {
    die("Invalid OTP!");
}

if (strtotime($otp['expires_at']) < time()) {
    die("OTP expired!");
}

echo "OTP Verified Successfully!";

header("Location: login.php");
exit;
