<?php
require 'db.php';

$user_id = 1;

$stmt = $pdo->prepare("
    SELECT tracking_code
    FROM shipments
    WHERE user_id = ?
    ORDER BY created_at DESC
");
$stmt->execute([$user_id]);
$shipments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Shipments</title>

<style>
* {
    box-sizing: border-box;
}

body {
    margin: 0;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial;
    background: #ffffff;
}

/* HEADER */
.header {
    display: flex;
    align-items: center;
    padding: 16px;
}

.back {
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.back img {
    width: 18px;
}

.title {
    flex: 1;
    text-align: center;
    font-size: 22px;
    font-weight: 700;
    color: #0b2c6f;
}

/* CONTAINER */
.container {
    padding: 16px;
}

/* BLUE STRIP */
.shipment-row {
    background: #0b2c6f;
    padding: 16px;
    margin-bottom: 20px;
    border-radius: 10px;
    display: flex;
    justify-content: flex-end;
}

/* RIGHT CONTENT */
.shipment-content {
    width: 70%;
    max-width: 320px;
}

/* LABEL */
.shipment-label {
    color: #ffffff;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
}

/* WHITE CARD */
.shipment-card {
    background: #ffffff;
    border-radius: 10px;
    padding: 16px;
}

/* TRACKING CODE */
.tracking-code {
    font-size: 18px;
    font-weight: 700;
    color: #000;
}
/* DESKTOP FIX – keep mobile untouched */
@media (min-width: 768px) {
    .shipment-row {
        max-width: 720px;     /* controls blue width */
        margin-left: auto;
        margin-right: auto;
    }

    .shipment-content {
        width: 55%;
    }
}


/* WARNING */
.warning {
    font-size: 12px;
    color: #999;
    margin-top: 6px;
    display: flex;
    align-items: center;
    gap: 4px;
}

/* LINK */
.shipment-link {
    text-decoration: none;
    width: 100%;
}
</style>
</head>

<body>

<div class="header">
    <div class="back" onclick="history.back()">
        <img src="assets/arrow.png" alt="Back">
    </div>
    <div class="title">My Shipments</div>
</div>

<div class="container">

<?php if ($shipments): ?>
    <?php foreach ($shipments as $shipment): ?>
        <a href="track-result.php?code=<?= urlencode($shipment['tracking_code']) ?>" class="shipment-link">

            <div class="shipment-row">

                <div class="shipment-content">

                    <div class="shipment-label">
                        🏷️ Tracking ID
                    </div>

                    <div class="shipment-card">
                        <div class="tracking-code">
                            <?= htmlspecialchars($shipment['tracking_code']) ?>
                        </div>

                        <div class="warning">
                            ⚠️ Ensure keeping this code safe
                        </div>
                    </div>

                </div>

            </div>

        </a>
    <?php endforeach; ?>
<?php endif; ?>

</div>

</body>
</html>
