<?php
require 'db.php';

$code = $_GET['code'] ?? null;
if (!$code) {
    die("Tracking code missing");
}

/* 🔍 Fetch shipment + tracking progress */
$stmt = $pdo->prepare("
    SELECT 
        s.tracking_code,
        s.status,
        s.created_at,

        t.current_status,
        t.current_location AS current_location,   -- <-- should be 'lat,lng'

        -- Sender
        a.city  AS sender_city,
        a.state AS sender_state,
        a.country AS sender_country,

        -- Receiver
        r.first_name AS receiver_name,
        r.city  AS receiver_city,
        r.state AS receiver_state,
        r.country AS receiver_country

    FROM shipments s

    LEFT JOIN tracking t 
        ON t.shipment_id = s.id

    LEFT JOIN addresses a 
        ON a.id = s.sender_id

    LEFT JOIN reciever_addresses r 
        ON r.id = s.receiver_id

    WHERE s.tracking_code = ?
    LIMIT 1
");
$stmt->execute([$code]);
$shipment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$shipment) {
    die("Tracking code not found");
}

// Split latitude and longitude
$lat = $lng = null;
if (!empty($shipment['current_location'])) {
    $coords = explode(',', $shipment['current_location']);
    if (count($coords) == 2) {
        $lat = trim($coords[0]);
        $lng = trim($coords[1]);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Tracking Result</title>

<style>
body{
    font-family:-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    background:#fff;
    color:#0b2c6f;
}
.wrap{
    max-width:480px;
    width:95%;
    margin:auto;
    padding:20px;
}
.card{
    background:#f4f6f9;
    border-radius:16px;
    padding:20px;
    margin-bottom:16px;
    word-wrap: break-word;
}
h3{text-align:center;}
.badge{
    display:inline-block;
    padding:6px 12px;
    border-radius:12px;
    background:#0b4dff;
    color:#fff;
    font-size:13px;
}
.small{color:#666;font-size:14px;}
.map-container{
    width:100%;
    height:250px;
    border-radius:16px;
    overflow:hidden;
    margin-top:10px;
}
@media (max-width:400px){
    h3{font-size:1.25rem;}
    .card{padding:12px;}
    .badge{padding:4px 10px;font-size:12px;}
    .map-container{height:200px;}
}
</style>
</head>

<body>

<div class="wrap">
    <h3>Tracking Details</h3>

    <div class="card">
        <b>Tracking Code</b><br>
        <?= htmlspecialchars($shipment['tracking_code']) ?>
    </div>

    <div class="card">
        <b>Status</b><br>
        <span class="badge">
            <?= htmlspecialchars($shipment['current_status'] ?? 'Processing') ?>
        </span>
    </div>

    <div class="card">
        <b>From</b><br>
        <?= htmlspecialchars($shipment['sender_city']) ?>,
        <?= htmlspecialchars($shipment['sender_state']) ?><br>
        <span class="small"><?= htmlspecialchars($shipment['sender_country']) ?></span>
    </div>

    <div class="card">
        <b>To</b><br>
        <strong><?= htmlspecialchars($shipment['receiver_name']) ?></strong><br>
        <?= htmlspecialchars($shipment['receiver_city']) ?>,
        <?= htmlspecialchars($shipment['receiver_state']) ?><br>
        <span class="small"><?= htmlspecialchars($shipment['receiver_country']) ?></span>
    </div>

    <div class="card">
        <b>Current Location</b><br>
        <?= htmlspecialchars($shipment['current_location'] ?? 'Location not updated') ?>

        <?php if($lat && $lng): ?>
        <div id="map" class="map-container"></div>
        <script>
        function initMap() {
            var location = {lat: <?= $lat ?>, lng: <?= $lng ?>};
            var map = new google.maps.Map(document.getElementById('map'), {
                zoom: 12,
                center: location
            });
            var marker = new google.maps.Marker({
                position: location,
                map: map,
                title: 'Current Location'
            });
        }
        </script>
        <script async defer src="https://maps.googleapis.com/maps/api/js?key=YOUR_GOOGLE_MAPS_API_KEY&callback=initMap"></script>
        <?php endif; ?>
    </div>

    <div class="card small">
        Shipment created on <?= date('d M Y', strtotime($shipment['created_at'])) ?>
    </div>
</div>

</body>
</html>
