<?php
session_start();

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    header("Location: sender-info.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Services</title>
<style>
*{box-sizing:border-box;}
body{
    margin:0;
    background:#f4f4f4;
    font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Helvetica,Arial;
    color:#333;
}
.app{
    max-width:420px;
    margin:auto;
    min-height:100vh;
    padding:16px;
}
/* Header */
.top{
    display:flex;
    justify-content:space-between;
    align-items:center;
    font-size:13px;
    color:#b0b0b0;
}
.top .active{color:#2f47ff;font-weight:600}
.close{
    width:28px;
    height:28px;
    border-radius:50%;
    background:#ff6b6b;
    color:#fff;
    display:flex;
    align-items:center;
    justify-content:center;
    font-size:18px;
    cursor:pointer;
}

h1{
    margin:18px 0;
    font-size:24px;
    color:#2f47ff;
}

/* Cards */
.card{
    position:relative;
    border-radius:18px;
    padding:20px;
    margin-bottom:18px;
    overflow:hidden;
    cursor:pointer;
    border:2px solid transparent;
    box-shadow:0 4px 10px rgba(0,0,0,0.1);
    transition: all 0.2s;
}
.card.selected{
    border-color:#2f47ff;
    box-shadow:0 6px 14px rgba(0,0,0,0.15);
}
.standard{background:#dff0d8;}
.express{background:#d8cf94;}

.card::after{
    content:"✈";
    position:absolute;
    right:-10px;
    bottom:-10px;
    font-size:140px;
    opacity:.08;
}

.price{
    font-size:26px;
    font-weight:700;
    color:#666;
}

.select-btn{
    position:absolute;
    top:16px;
    right:16px;
    padding:8px 14px;
    border-radius:8px;
    font-size:13px;
    font-weight:600;
    color:#fff;
}
.standard .select-btn{background:#6a1b9a;}
.express .select-btn{background:#5c6cff;}
.card.selected .select-btn{background:#0b4dff;}
.card.selected .select-btn::after{content:" ✓";}

.info{
    margin-top:16px;
    background:#fef8d9;
    border-radius:10px;
    padding:12px;
    width:68%;
}
.info h3{
    margin:0;
    font-size:14px;
    color:#1b5e20;
}
.info p{
    margin:4px 0;
    font-size:12px;
    color:#666;
}
.stars{
    margin-top:4px;
    color:#e57373;
    font-size:14px;
}

/* Continue */
button{
    margin-top:10px;
    width:100%;
    padding:16px;
    background:#0b4dff;
    border:none;
    border-radius:14px;
    color:#fff;
    font-size:16px;
    font-weight:600;
}

/* Radio */
input[type=radio]{display:none;}
label{display:block;cursor:pointer;}
</style>
</head>
<body>
<div class="app">

    <div class="top">
        <div>Sender - Receiver - Items - Insurance - <span class="active">Services</span></div>
        <div class="close" onclick="history.back()">×</div>
    </div>

    <h1>Services</h1>

    <form id="serviceForm">

        <label class="card standard" data-service="standard" data-price="5000.25">
            <div class="price">₦5,000.25</div>
            <div class="select-btn">Select</div>

            <div class="info">
                <h3>Standard Service</h3>
                <p>Pick up: Within 2 days</p>
                <p>Delivery: Within 7 days</p>
                <div class="stars">★★★</div>
            </div>

            <input type="radio" name="service" value="standard">
        </label>

        <label class="card express" data-service="express" data-price="7200.00">
            <div class="price">₦7,200.00</div>
            <div class="select-btn">Select</div>

            <div class="info">
                <h3>Express service</h3>
                <p>Pick up: Within 2 days</p>
                <p>Delivery: Within 7 days</p>
                <div class="stars">★★★★★</div>
            </div>

            <input type="radio" name="service" value="express">
        </label>

        <button type="submit">Continue</button>
    </form>

</div>

<script>
const cards = document.querySelectorAll('.card');
let selectedCard = null;

cards.forEach(card=>{
    card.addEventListener('click', ()=>{
        cards.forEach(c=>{
            c.classList.remove('selected');
            c.querySelector('.select-btn').textContent = 'Select';
        });
        card.classList.add('selected');
        card.querySelector('.select-btn').textContent = 'Selected';
        selectedCard = card;
    });
});

document.getElementById('serviceForm').addEventListener('submit', function(e){
    e.preventDefault();
    if(!selectedCard){
        alert("Please select a service to continue.");
        return;
    }
    const service = selectedCard.dataset.service;
    const price = selectedCard.dataset.price;
    const shipment_id = new URLSearchParams(window.location.search).get('shipment_id');
    // Redirect with query string
    window.location.href = `review.php?shipment_id=${shipment_id}&service=${service}&price=${price}`;
});
</script>

</body>
</html>
