<?php
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    die("Shipment ID missing");
}

/* Fetch shipment */
$stmt = $pdo->prepare("SELECT sender_id FROM shipments WHERE id=?");
$stmt->execute([$shipment_id]);
$shipment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$shipment) {
    die("Shipment not found");
}

/* Fetch sender */
$stmt = $pdo->prepare("SELECT * FROM addresses WHERE id=?");
$stmt->execute([$shipment['sender_id']]);
$sender = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$sender) {
    die("Sender not found");
}

/* Save changes */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $first_name = trim($_POST['first_name']);
    $last_name  = trim($_POST['last_name']);
    $email      = trim($_POST['email']);
    $address1   = trim($_POST['address1']);
    $address2   = trim($_POST['address2']);

    $stmt = $pdo->prepare("
        UPDATE addresses 
        SET first_name=?, last_name=?, email=?, address1=?, address2=? 
        WHERE id=?
    ");
    $stmt->execute([
        $first_name,
        $last_name,
        $email,
        $address1,
        $address2,
        $shipment['sender_id']
    ]);

    header("Location: review.php?shipment_id=$shipment_id");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Edit Sender</title>
<style>
body{background:#f2f2f2;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto;}
.wrap{max-width:420px;margin:auto;padding:16px;}
.box{background:#fff;padding:20px;border-radius:14px;box-shadow:0 5px 15px rgba(0,0,0,.1);}
input{
    width:100%;
    padding:14px;
    margin-bottom:12px;
    border-radius:10px;
    border:1px solid #ddd;
}
button{
    width:100%;
    padding:16px;
    background:#0b4dff;
    border:none;
    border-radius:12px;
    color:#fff;
    font-size:16px;
}
</style>
</head>
<body>

<div class="wrap">
    <h3>Edit Sender</h3>

    <form method="POST" class="box">
        <input name="first_name" value="<?= htmlspecialchars($sender['first_name']) ?>" placeholder="First Name" required>
        <input name="last_name" value="<?= htmlspecialchars($sender['last_name']) ?>" placeholder="Last Name" required>
        <input name="email" value="<?= htmlspecialchars($sender['email']) ?>" placeholder="Email" required>
        <input name="address1" value="<?= htmlspecialchars($sender['address1']) ?>" placeholder="Address Line 1" required>
        <input name="address2" value="<?= htmlspecialchars($sender['address2']) ?>" placeholder="Address Line 2">

        <button type="submit">Save Changes</button>
    </form>
</div>

</body>
</html>
