<?php
require 'db.php';

/* ✅ Validate shipment ID */
$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    die("Shipment ID missing");
}

/* ✅ Fetch shipment to get receiver_id */
$stmt = $pdo->prepare("
    SELECT receiver_id 
    FROM shipments 
    WHERE id = ?
");
$stmt->execute([$shipment_id]);
$shipment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$shipment || empty($shipment['receiver_id'])) {
    die("Receiver not linked to this shipment");
}

$receiver_id = (int) $shipment['receiver_id'];

/* ✅ Fetch receiver details */
$stmt = $pdo->prepare("
    SELECT first_name, last_name, email, address1, address2
    FROM reciever_addresses 
    WHERE id = ?
");
$stmt->execute([$receiver_id]);
$receiver = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$receiver) {
    die("Receiver not found");
}

/* ✅ Save edited receiver */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $first_name = trim($_POST['first_name']);
    $last_name  = trim($_POST['last_name']);
    $email      = trim($_POST['email']);
    $address1   = trim($_POST['address1']);
    $address2   = trim($_POST['address2']);

    if (!$first_name || !$last_name || !$email || !$address1) {
        die("All required fields must be filled");
    }

    $stmt = $pdo->prepare("
        UPDATE reciever_addresses
        SET first_name = ?, 
            last_name  = ?, 
            email      = ?, 
            address1   = ?, 
            address2   = ?
        WHERE id = ?
    ");
    $stmt->execute([
        $first_name,
        $last_name,
        $email,
        $address1,
        $address2,
        $receiver_id
    ]);

    header("Location: review.php?shipment_id=$shipment_id");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Edit Receiver</title>

<style>
body{
    background:#f2f2f2;
    font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto;
    margin:0;
}
.wrap{max-width:420px;margin:auto;padding:16px;}
.box{
    background:#fff;
    padding:20px;
    border-radius:14px;
    box-shadow:0 5px 15px rgba(0,0,0,.1);
}
input{
    width:100%;
    padding:14px;
    margin-bottom:12px;
    border-radius:10px;
    border:1px solid #ddd;
    font-size:14px;
}
button{
    width:100%;
    padding:16px;
    background:#0b4dff;
    border:none;
    border-radius:12px;
    color:#fff;
    font-size:16px;
    cursor:pointer;
}
</style>
</head>
<body>

<div class="wrap">
    <h3>Edit Receiver</h3>

    <form method="POST" class="box">
        <input name="first_name" value="<?= htmlspecialchars($receiver['first_name']) ?>" placeholder="First Name" required>
        <input name="last_name" value="<?= htmlspecialchars($receiver['last_name']) ?>" placeholder="Last Name" required>
        <input name="email" value="<?= htmlspecialchars($receiver['email']) ?>" placeholder="Email" required>
        <input name="address1" value="<?= htmlspecialchars($receiver['address1']) ?>" placeholder="Address Line 1" required>
        <input name="address2" value="<?= htmlspecialchars($receiver['address2']) ?>" placeholder="Address Line 2">
        <button type="submit">Save Changes</button>
    </form>
</div>

</body>
</html>
