<?php
session_start();
require 'db.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    die("Access denied. Please log in.");
}

$user_id = $_SESSION['user_id'];

// Fetch current user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

$success_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $phone     = trim($_POST['phone']);
    $location  = trim($_POST['location']);
    $bvn       = trim($_POST['bvn']);

    // Split full name into first_name and last_name
    $name_parts = explode(' ', $full_name, 2);
    $first_name = $name_parts[0];
    $last_name  = $name_parts[1] ?? '';

    // Hash BVN as password
    $password_hash = password_hash($bvn, PASSWORD_DEFAULT);

    // Update the user
    $stmt = $pdo->prepare("UPDATE users SET 
        first_name = ?, 
        last_name = ?, 
        phone = ?, 
        location = ?, 
        password = ? 
        WHERE id = ?");
    $stmt->execute([$first_name, $last_name, $phone, $location, $password_hash, $user_id]);

    $success_message = "Profile updated successfully!";

    // Refresh user data
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Profile</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #ffffff; font-family: "Helvetica Neue", Arial, sans-serif; margin: 0; }
.page-container { min-height: 100vh; padding: 25px; }
.header { text-align:center; font-size:22px; font-weight:600; margin-bottom:25px; position:relative; }
.close-btn { position:absolute; right:0; top:0; background:#ff6464; color:#fff; width:28px; height:28px; border-radius:50%; text-align:center; line-height:28px; font-weight:bold; cursor:pointer; }
.avatar { width:110px; height:110px; border-radius:50%; background:#4fb8a6; margin:0 auto 30px; display:flex; align-items:center; justify-content:center; }
.avatar img { width:70px; }
.white-input { width:100%; padding:14px; border-radius:12px; background:#fff; border:1.5px solid #dcdcdc; margin-bottom:14px; font-size:15px; }
.white-input:focus { outline:none; border-color:#007bff; box-shadow:0 0 4px rgba(0,132,255,0.25); }
.bvn-note { font-size:12px; color:#ff6464; margin-top:-8px; margin-bottom:40px; }
.main-btn { width:100%; background:#0053f1; padding:14px; border-radius:12px; text-align:center; font-weight:600; color:#fff; border:none; font-size:16px; }
.success-msg { text-align:center; color:green; margin-bottom:20px; font-weight:600; }
</style>
</head>
<body>
     <style>
        body {
            background: #ffffff;
            font-family: "Helvetica Neue", Arial, sans-serif;
            margin: 0;
        }

        .page-container {
            min-height: 100vh;
            padding: 25px;
        }

        .header {
            text-align: center;
            font-size: 22px;
            font-weight: 600;
            margin-bottom: 25px;
            position: relative;
        }

        .close-btn {
            position: absolute;
            right: 0;
            top: 0;
            background: #ff6464;
            color: #fff;
            width: 28px;
            height: 28px;
            border-radius: 50%;
            text-align: center;
            line-height: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .avatar {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            background: #4fb8a6;
            margin: 0 auto 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .avatar img {
            width: 70px;
        }

        .white-input {
            width: 100%;
            padding: 14px;
            border-radius: 12px;
            background: #fff;
            border: 1.5px solid #dcdcdc;
            margin-bottom: 14px;
            font-size: 15px;
        }

        .white-input:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 4px rgba(0, 132, 255, 0.25);
        }

        .bvn-note {
            font-size: 12px;
            color: #ff6464;
            margin-top: -8px;
            margin-bottom: 40px;
        }

        .main-btn {
            width: 100%;
            background: #0053f1;
            padding: 14px;
            border-radius: 12px;
            text-align: center;
            font-weight: 600;
            color: #fff;
            border: none;
            font-size: 16px;
        }
    </style>

<div class="page-container">

    <div class="header">
        Profile
        <div class="close-btn" onclick="window.close()">×</div>
    </div>

    <div class="avatar">
        <img src="assets/profile.png" alt="avatar">
    </div>

    <?php if(!empty($success_message)) echo '<div class="success-msg">'.$success_message.'</div>'; ?>

    <!-- Profile Form -->
    <form style="max-width:420px; margin:auto;" method="POST">

        <input type="text" name="full_name" class="white-input" placeholder="Full Name" value="<?= htmlspecialchars($user['first_name'].' '.$user['last_name']) ?>" required>

        <input type="tel" name="phone" class="white-input" placeholder="Phone number" value="<?= htmlspecialchars($user['phone'] ?? '') ?>" required>

        <input type="text" name="location" class="white-input" placeholder="Location" value="<?= htmlspecialchars($user['location'] ?? '') ?>" required>

        <input type="password" name="bvn" class="white-input" placeholder="BVN" required>

        <div class="bvn-note">
            *Verify your BVN with your Banks
        </div>

        <button type="submit" class="main-btn">Save</button>

    </form>

</div>

</body>
</html>
