<?php
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) die("Missing shipment ID");

$stmt = $pdo->prepare("SELECT service_price, insurance_amount FROM shipments WHERE id=?");
$stmt->execute([$shipment_id]);
$ship = $stmt->fetch(PDO::FETCH_ASSOC);

$shipping = $ship['service_price'];
$insurance = $ship['insurance_amount'];
$total = $shipping + $insurance;
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Make Payment</title>
<style>
body{
    background:#f2f2f2;
    font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto;
    margin:0;
}
.wrap{max-width:420px;margin:auto;padding:20px;}
.card{
    background:#fff;
    border-radius:18px;
    padding:24px;
    text-align:center;
    box-shadow:0 10px 30px rgba(0,0,0,.1);
}
.amount{
    background:#0b4dff;
    color:#fff;
    padding:12px;
    border-radius:8px;
    font-size:20px;
    font-weight:700;
    display:inline-block;
    margin:10px 0 20px;
}
.row{
    display:flex;
    justify-content:space-between;
    font-size:14px;
    color:#666;
    margin-bottom:6px;
}
.pay-btn{
    margin-top:40px;
    background:#7ee293;
    border:none;
    width:100%;
    padding:18px;
    font-size:16px;
    border-radius:12px;
    cursor:pointer;
}
</style>
</head>
<body>
<div class="header">
    <h3></h3>
    <a href="reciever_info.php"><img src="assets/cancel.png" class="close-icon"></a>
</div>
<style>
.header{
    display:flex;
    justify-content:space-between;
    align-items:center;
}
.close-icon{
    width:22px;
    height:22px;
    cursor:pointer;
}

</style>
<div class="wrap">
    <div class="card"style="margin-top:70px;">
        😎
        <h3>Make Payment</h3>
        <div class="amount">₦<?= number_format($total,2) ?></div>

        <div class="row"><span>Shipping Charge</span><span>₦<?= number_format($shipping,2) ?></span></div>
        <div class="row"><span>Insurance</span><span>₦<?= number_format($insurance,2) ?></span></div>
        <div class="row"><b>Total</b><b>₦<?= number_format($total,2) ?></b></div>
    </div>

    <button class="pay-btn"
        onclick="location.href='pay-method.php?shipment_id=<?= $shipment_id ?>'">
        Make Payment
    </button>
</div>

</body>
</html>
