<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <title>Packaging</title>

    <style>
        body {
            background: #f2f2f2;
            font-family: "Helvetica Neue", Arial, sans-serif;
            margin: 0;
        }

        /* HEADER */
        .app-header {
            background: #fff;
            padding: 14px 18px;
            display: flex;
            align-items: center;
            gap: 12px;
            border-bottom: 1px solid #eee;
        }

        .back-btn {
            width: 34px;
            height: 34px;
            background: #4c5cff;
            color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
        }

        .page-title {
            font-size: 22px;
            font-weight: 700;
            color: #4c5cff;
        }

        /* CONTENT */
        .content {
            padding: 18px;
            max-width: 900px;
            margin: auto;
        }

        /* PACKAGING CARD */
        .pack-card {
            background: #cfe0ff;
            border-radius: 14px;
            padding: 16px;
            margin-bottom: 18px;
        }

        .pack-img {
            width: 100%;
            max-height: 200px;
            object-fit: contain;
            margin-bottom: 14px;
        }

        .price-bar {
            background: #b6ff8f;
            border-radius: 8px;
            padding: 10px;
            text-align: center;
            font-weight: 600;
            font-size: 15px;
        }

        .price {
            font-weight: 700;
            font-size: 14px;
        }

        /* DESKTOP */
        @media (min-width: 768px) {
            .pack-img {
                max-height: 240px;
            }
        }
    </style>
</head>

<body>

<!-- HEADER -->
<div class="app-header">
    <div class="back-btn" onclick="history.back()">&#8592;</div>
    <div class="page-title">Packaging</div>
</div>

<!-- CONTENT -->
<div class="content">

    <!-- Carrier Bags -->
    <div class="pack-card">
        <img src="assets/pp1.png" class="pack-img">
        <div class="price-bar">
            -Carrier Bags- <br>
            <span class="price">NGN 3,500</span>
        </div>
    </div>

    <!-- Boxes -->
    <div class="pack-card">
        <img src="assets/pp1.png" class="pack-img">
        <div class="price-bar">
            -Boxes- <br>
            <span class="price">NGN 2,500</span>
        </div>
    </div>

    <!-- Shipping Documentation -->
    <div class="pack-card">
        <img src="assets/pp1.png" class="pack-img">
        <div class="price-bar">
            Shipping Documentation <br>
            <span class="price">NGN 5,500</span>
        </div>
    </div>

    <!-- Shipping Documentation (Repeated as in Figma) -->
    <div class="pack-card">
        <img src="assets/pp1.png" class="pack-img">
        <div class="price-bar">
            Shipping Documentation <br>
            <span class="price">NGN 5,500</span>
        </div>
    </div>

</div>

</body>
</html>
