<?php
session_start();
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    header("Location: sender-info.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("
        INSERT INTO shipment_items
        (shipment_id, item_name, category, sub_category, weight, quantity, item_value)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([
        $shipment_id,
        $_POST['item_name'],
        $_POST['category'],
        $_POST['sub_category'],
        $_POST['weight'],
        $_POST['quantity'],
        $_POST['item_value']
    ]);

    header("Location: insurance.php?shipment_id=$shipment_id");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Describe Item</title>
    <style>
        body {
            background: #f3f3f3;
            font-family: "Helvetica Neue", Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        /* TOP BAR */
        .top-bar {
            padding: 14px 18px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        .steps {
            font-size: 13px;
            color: #9aa0a6;
        }
        .steps span.active {
            color: #1e88ff;
            font-weight: 600;
        }
        .close-btn {
            width: 28px;
            height: 28px;
            background: #f15b5b;
            color: #fff;
            border-radius: 50%;
            font-size: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
        }

        /* CONTAINER */
        .container {
            max-width: 480px;
            width: 90%;
            margin: 40px auto;
            padding: 20px;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        h2 {
            color: #2d3cff;
            font-size: 24px;
            margin-bottom: 20px;
            text-align: center;
        }

        input, select {
            width: 100%;
            padding: 14px;
            border-radius: 14px;
            border: 1.5px solid #ddd;
            background: #f3f3f3;
            margin-bottom: 14px;
            font-size: 15px;
        }

        input::placeholder {
            color: #9a9a9a;
        }

        button {
            background: #0047ff;
            color: #fff;
            padding: 16px;
            width: 100%;
            border: none;
            border-radius: 14px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        button:hover {
            transform: scale(1.03);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }

        @media (max-width: 400px) {
            h2 { font-size: 20px; }
            input, select { padding: 12px; font-size: 14px; }
            button { padding: 14px; font-size: 15px; }
        }
    </style>
</head>
<body>

<!-- TOP BAR -->
<div class="top-bar">
    <div class="steps">
        Sender - Receiver - <span class="active">Items</span> - Services - Insurance
    </div>
    <div class="close-btn" onclick="history.back()">×</div>
</div>

<!-- CONTENT -->
<div class="container">
    <h2>Describe your Item</h2>

    <form method="POST">
        <input type="text" name="item_name" placeholder="Item name" required>
        <select name="category" required>
            <option value="">Item Category</option>
            <option>Electronics</option>
            <option>Documents</option>
            <option>Clothing</option>
        </select>
        <select name="sub_category" required>
            <option value="">Item Sub-Category</option>
            <option>Phones</option>
            <option>Laptops</option>
            <option>Accessories</option>
        </select>

        <input type="number" step="0.01" name="weight" placeholder="Weight (kg)" required>
        <input type="number" name="quantity" value="1" placeholder="Quantity" required>
        <input type="text" name="item_value" placeholder="NGN 10,000" required>

        <button type="submit">Continue</button>
    </form>
</div>

</body>
</html>
