<?php
session_start();
require 'db.php';

$shipment_id = $_GET['shipment_id'] ?? null;
if (!$shipment_id) {
    header("Location: sender-info.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("UPDATE shipments SET insurance_amount = ? WHERE id = ?");
    $stmt->execute([800, $shipment_id]);

    header("Location: services.php?shipment_id=$shipment_id");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Purchase Insurance</title>

<style>
/* RESET */
* {
    box-sizing: border-box;
    -webkit-tap-highlight-color: transparent;
}

body {
    margin: 0;
    background: #f2f2f2;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
    color: #333;
}

/* TOP STEPS */
.top {
    padding: 18px 16px 10px;
    font-size: 13px;
    color: #9aa0a6;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.top span.active {
    color: #2d43ff;
    font-weight: 600;
}

.close {
    width: 28px;
    height: 28px;
    background: #f25c5c;
    color: #fff;
    border-radius: 50%;
    font-size: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
}

/* PAGE CONTENT */
.page {
    padding: 20px 16px 32px;
    max-width: 480px;
    margin: auto;
}

h1 {
    color: #2d43ff;
    font-size: 28px;
    font-weight: 700;
    margin: 12px 0 28px;
}

/* INSURANCE ROW */
.insurance-box {
    background: #f7f7f7;
    border-radius: 12px;
    padding: 18px 16px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border: 1px solid #e0e0e0;
}

.insurance-left {
    display: flex;
    flex-direction: column;
    gap: 6px;
}

.insurance-left span {
    font-size: 14px;
    color: #777;
}

.amount {
    font-size: 18px;
    color: #b5b5b5;
    font-weight: 600;
}

.select-btn {
    background: #6fb04f;
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 10px 14px;
    font-size: 14px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 6px;
}

/* CONTINUE BUTTON */
.continue {
    margin-top: 40px;
}

.continue button {
    width: 100%;
    padding: 18px;
    background: #0b4dff;
    border: none;
    border-radius: 12px;
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
}

/* MOBILE SMALL */
@media (max-width: 360px) {
    h1 {
        font-size: 24px;
    }

    .amount {
        font-size: 16px;
    }

    .select-btn {
        padding: 8px 12px;
        font-size: 13px;
    }
}
</style>
</head>

<body>

<!-- TOP -->
<div class="top">
    <div>
        Sender - Receiver - Items - <span class="active">Insurance</span> - Services
    </div>
    <div class="close" onclick="history.back()">×</div>
</div>

<!-- CONTENT -->
<div class="page">
    <h1>Purchase Insurance</h1>

    <form method="POST">
        <div class="insurance-box">
            <div class="insurance-left">
                <span>ShipBeta</span>
                <div class="amount">₦800.00</div>
            </div>
            <div class="select-btn">
                Select ✓
            </div>
        </div>

        <div class="continue">
            <button type="submit">Continue</button>
        </div>
    </form>
</div>

</body>
</html>
