<?php
// header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Extra safety
if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    die("Access denied");
}
?>

<!-- Admin Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
    <div class="container-fluid px-3 px-md-4">

        <!-- Brand -->
        <a class="navbar-brand fw-bold" href="admin-dashboard.php">
            🚚 ShipAdmin
        </a>

        <!-- Toggle button for mobile -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#adminNavbar" aria-controls="adminNavbar" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- Navbar links -->
        <div class="collapse navbar-collapse" id="adminNavbar">
            <!-- Left Menu -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link" href="admin-dashboard.php">Dashboard</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="admin-shipments.php">Shipments</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="admin_users.php">Users</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="admin-payment.php">Payments</a>
                </li>
            </ul>

            <!-- Right Menu -->
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Admin
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="adminDropdown">
                        <li>
                            <a class="dropdown-item" href="admin-profile.php">Profile</a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="admin-logout.php">Logout</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Optional custom styling -->
<style>
/* Make brand text more visible on small screens */
.navbar-brand {
    font-size: 1.2rem;
}

.nav-link.active {
    font-weight: 600;
}

.navbar-nav .nav-link {
    padding: 0.5rem 1rem;
}

@media (max-width: 576px) {
    .navbar-nav {
        text-align: center;
    }
    .navbar-nav .nav-link {
        padding: 0.5rem 0;
    }
}
</style>
