<?php
session_start();
require 'db.php';

/* 🔐 User must be logged in */
if (!isset($_SESSION['user_id'])) {
    die("Please login to continue");
}

$user_id = $_SESSION['user_id'];

/* Fetch current wallet balance */
$stmt = $pdo->prepare("SELECT balance FROM wallets WHERE user_id = ?");
$stmt->execute([$user_id]);
$wallet = $stmt->fetch(PDO::FETCH_ASSOC);
$balance = $wallet ? $wallet['balance'] : 0;
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Fund Wallet</title>
<style>
body{background:#f2f2f2;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto;margin:0;}
.wrap{max-width:420px;margin:auto;padding:20px;}
.card{background:#fff;border-radius:18px;padding:24px;text-align:center;box-shadow:0 10px 30px rgba(0,0,0,.1);}
.balance{background:#0b4dff;color:#fff;padding:14px;border-radius:10px;font-size:18px;font-weight:700;margin-bottom:25px;}
input{width:100%;padding:16px;font-size:16px;border-radius:12px;border:1px solid #ddd;outline:none;}
input:focus{border-color:#0b4dff;}
.btn{margin-top:30px;background:#7ee293;border:none;width:100%;padding:18px;font-size:16px;border-radius:12px;cursor:pointer;}
.note{font-size:13px;color:#777;margin-top:15px;}
</style>
</head>
<body>
<div class="wrap">
    <div class="card">
        💰
        <h3>Fund Your Wallet</h3>
        <div class="balance">
            Current Balance: ₦<?= number_format($balance, 2) ?>
        </div>
        <form method="POST" action="wallet-pay.php">
            <input type="number" name="amount" placeholder="Enter amount (₦)" min="100" required>
            <button class="btn" type="submit">Continue to Payment</button>
        </form>
        <div class="note">
            Funds will be added to your wallet after successful payment.
        </div>
    </div>
</div>
</body>
</html>
