<?php
session_start();
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $shipment_id = $_POST['shipment_id'];
    $new_location = $_POST['location'];

    // Update shipment location
    $stmt = $pdo->prepare("UPDATE shipments SET location = ? WHERE id = ?");
    $stmt->execute([$new_location, $shipment_id]);

    header("Location: admin_dashboard.php");
    exit;
}

$shipment_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM shipments WHERE id = ?");
$stmt->execute([$shipment_id]);
$shipment = $stmt->fetch();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Shipment</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h2>Edit Shipment Location</h2>
    <form method="POST">
        <input type="hidden" name="shipment_id" value="<?php echo $shipment['id']; ?>">
        <div class="mb-3">
            <label for="location" class="form-label">New Location</label>
            <input type="text" class="form-control" id="location" name="location" value="<?php echo htmlspecialchars($shipment['location']); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Save Changes</button>
    </form>
</div>

</body>
</html>
