<?php
session_start();
require 'db.php';
include 'header.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    die("Access denied");
}

$stmt = $pdo->query("
    SELECT id, first_name, last_name, email, created_at
    FROM users
    ORDER BY created_at DESC
");

$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin – Users</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f4f6f9; }
.card { border-radius:16px; }
.table thead th {
    font-size:13px;
    text-transform:uppercase;
    color:#6c757d;
}
</style>
</head>

<body>

<div class="container mt-4">

    <div class="card shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">All Users</h5>
                <span class="text-muted small"><?= count($users) ?> total</span>
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Full Name</th>
                            <th>Email</th>
                            <th>Date Joined</th>
                        </tr>
                    </thead>
                    <tbody>

                    <?php if (!$users): ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted">
                                No users found
                            </td>
                        </tr>
                    <?php endif; ?>

                    <?php foreach ($users as $u): ?>
                        <tr>
                            <td><?= $u['id']; ?></td>
                            <td>
                                <?= htmlspecialchars($u['first_name'] . ' ' . $u['last_name']); ?>
                            </td>
                            <td><?= htmlspecialchars($u['email']); ?></td>
                            <td class="text-muted small">
                                <?= date('d M Y', strtotime($u['created_at'])); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>
                </table>
            </div>

        </div>
    </div>

</div>

</body>
</html>
