<?php
session_start();
require 'db.php';
include 'header.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    die("Access denied");
}

$stmt = $pdo->query("
    SELECT 
        wt.id,
        wt.amount,
        wt.type,
        wt.reference,
        wt.status,
        wt.created_at,
        u.first_name,
        u.last_name,
        u.email
    FROM wallet_transactions wt

    LEFT JOIN wallets w 
        ON w.id = wt.wallet_id

    LEFT JOIN users u 
        ON u.id = w.user_id

    ORDER BY wt.created_at DESC
");

$payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin – Wallet Payments</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#f4f6f9; }
.card { border-radius:16px; }
.table thead th {
    font-size:13px;
    text-transform:uppercase;
    color:#6c757d;
}
.badge-status {
    padding:6px 10px;
    border-radius:12px;
    font-size:12px;
}
</style>
</head>

<body>

<div class="container mt-4">

    <div class="card shadow-sm">
        <div class="card-body">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Wallet Transactions</h5>
                <span class="text-muted small"><?= count($payments) ?> total</span>
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>Reference</th>
                            <th>User</th>
                            <th>Amount</th>
                            <th>Type</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>

                    <?php if (!$payments): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">
                                No transactions found
                            </td>
                        </tr>
                    <?php endif; ?>

                    <?php foreach ($payments as $p): ?>
                        <tr>
                            <td><strong><?= htmlspecialchars($p['reference']); ?></strong></td>

                            <td class="small">
                                <?= htmlspecialchars($p['first_name'] . ' ' . $p['last_name']); ?><br>
                                <span class="text-muted"><?= htmlspecialchars($p['email']); ?></span>
                            </td>

                            <td>
                                ₦<?= number_format($p['amount'], 2); ?>
                            </td>

                            <td>
                                <span class="badge bg-info badge-status">
                                    <?= ucfirst($p['type']); ?>
                                </span>
                            </td>

                            <td>
                                <span class="badge bg-<?= $p['status'] === 'success' ? 'success' : 'secondary'; ?> badge-status">
                                    <?= ucfirst($p['status']); ?>
                                </span>
                            </td>

                            <td class="text-muted small">
                                <?= date('d M Y', strtotime($p['created_at'])); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>
                </table>
            </div>

        </div>
    </div>

</div>

</body>
</html>
