<?php
require 'db.php';

// Fetch all shortlet properties
$query = $conn->query("SELECT * FROM properties WHERE type='shortlet' ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Shortlet Properties</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    /* Navbar styles */
    .navbar-custom {
      background-color: #000;
    }
    .navbar-custom .nav-link, .navbar-custom .navbar-brand {
      color: #fff;
    }
    .navbar-custom .nav-link:hover {
      color: #ddd;
    }

    /* Property card */
    .card-property {
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .card-property:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 20px rgba(0,0,0,0.2);
    }
    .card-property img {
      height: 200px;
      object-fit: cover;
    }
    .card-title {
      font-size: 1.1rem;
      font-weight: 600;
    }
    .price {
      font-weight: bold;
      color: #1a1a1a;
    }
  </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark navbar-custom mb-4">
  <div class="container">
    <a class="navbar-brand" href="index.php">Tbil Properties</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="buy.php">Buy Property</a></li>
        <li class="nav-item"><a class="nav-link" href="rent.php">Rent Property</a></li>
        <li class="nav-item"><a class="nav-link active" href="shortlet.php">Shortlet</a></li>
        <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>
</nav>

<!-- Page Header -->
<div class="container mb-4">
  <h2 class="fw-bold">Shortlet Properties</h2>
  <p>Explore our latest shortlet listings available for temporary stays.</p>
</div>

<!-- Property Grid -->
<div class="container">
  <div class="row g-4">
    <?php while($row = $query->fetch_assoc()): ?>
      <div class="col-md-4 col-sm-6">
        <div class="card card-property shadow-sm">
          <img src="<?= htmlspecialchars($row['img']); ?>" class="card-img-top" alt="<?= htmlspecialchars($row['title']); ?>">
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($row['title']); ?></h5>
            <p class="price">₦<?= number_format($row['price']); ?></p>
            <p class="text-muted"><?= htmlspecialchars($row['location']); ?></p>
            <a href="view_single_property.php?id=<?= $row['id']; ?>" style="background-color:#000" class="btn btn-primary w-100">View Details</a>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
