<?php
require 'db.php';
include 'navbar.php';
// Fetch all properties available for rent
$query = $conn->query("SELECT * FROM properties WHERE type='rent' ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Rent a Property</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
 

    /* Property card */
    .card-property {
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .card-property:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 20px rgba(0,0,0,0.2);
    }
    .card-property img {
      height: 200px;
      object-fit: cover;
    }
    .card-title {
      font-size: 1.1rem;
      font-weight: 600;
    }
    .price {
      font-weight: bold;
      color: #1a1a1a;
    }
  </style>
</head>
<body>

<!-- Page Header -->
<div class="container mb-4">
  <h2 class="fw-bold">Properties Available for Rent</h2>
  <p>Browse our latest rental listings across Nigeria.</p>
</div>

<!-- Property Grid -->
<div class="container">
  <div class="row g-4">
    <?php while($row = $query->fetch_assoc()): ?>
      <div class="col-md-4 col-sm-6">
        <div class="card card-property shadow-sm">
          <img src="<?= htmlspecialchars($row['img']); ?>" class="card-img-top" alt="<?= htmlspecialchars($row['title']); ?>">
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($row['title']); ?></h5>
            <p class="price">₦<?= number_format($row['price']); ?> / month</p>
            <p class="text-muted"><?= htmlspecialchars($row['location']); ?></p>
            <a href="view_single_property.php?id=<?= $row['id']; ?>"style="background-color:#000" class="btn btn-primary w-100">View Details</a>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
