<?php include 'navbar.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Property Management | Tbil Properties</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    /* Hero Section */
    .hero-section {
      height: 90vh;
      background: url('assets/img/tz1.jpg') center/cover no-repeat;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
      color: white;
      position: relative;
    }
    .hero-section::before {
      content: '';
      position: absolute;
      top:0; left:0;
      width:100%; height:100%;
      background: rgba(0,0,0,0.5);
    }
    .hero-section .hero-content {
      position: relative;
      z-index: 2;
    }
    .hero-section h1 {
      font-size: 3rem;
      font-weight: bold;
    }
    .hero-section p {
      font-size: 1.2rem;
      margin-bottom: 20px;
    }

    /* Services Section */
    .service-card {
      background: #fff;
      border-radius: 12px;
      padding: 25px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.1);
      transition: all .3s ease;
      cursor: pointer;
      text-align: center;
      margin-bottom: 30px;
    }
    .service-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 12px 30px rgba(0,0,0,0.15);
    }
    .service-icon {
      font-size: 40px;
      margin-bottom: 15px;
      color: #000; /* Black icons */
    }

    /* CTA Button */
    .cta-btn {
      background-color: #28a745;
      color: white;
      padding: 15px 30px;
      font-size: 1.1rem;
      border-radius: 8px;
      text-decoration: none;
      display: inline-block;
      transition: all 0.3s ease;
    }
    .cta-btn:hover {
      background-color: #1e7e34;
      color: white;
      text-decoration: none;
    }
    .bg-tenant {
  background-color: #ffdede; /* light red/pink */
  color: #000;
}

.bg-maintenance {
  background-color: #defff0; /* light green */
  color: #000;
}

.bg-financial {
  background-color: #dedefe; /* light blue/purple */
  color: #000;
}

  </style>
</head>
<body>

<!-- HERO SECTION -->
<section class="hero-section">
  <div class="hero-content">
    <h1>Professional Property Management</h1>
    <p>We help property owners maximize ROI, manage tenants, and keep properties in top condition. Stress-free property management starts here.</p>
    <a href="https://wa.link/ira501" target="_blank" class="cta-btn">
      <i class="bi bi-whatsapp"></i> Contact Us on WhatsApp
    </a>
  </div>
</section>

<!-- SERVICES SECTION -->
<section class="py-5">
  <div class="container">
    <h2 class="text-center mb-5">Our Property Management Services</h2>
    <div class="row g-4">
      <div class="col-md-4">
        <div class="service-card bg-tenant">
          <i class="bi bi-building service-icon"></i>
          <h4 class="fw-bold mb-2">Tenant Management</h4>
          <p>We handle tenant inquiries, screening, contracts, and ensure timely rent collection.</p>
        </div>
      </div>
      <div class="col-md-4">
        <div class="service-card bg-maintenance">
          <i class="bi bi-tools service-icon"></i>
          <h4 class="fw-bold mb-2">Maintenance & Repairs</h4>
          <p>Regular property inspections and maintenance to keep your assets in excellent condition.</p>
        </div>
      </div>
      <div class="col-md-4">
        <div class="service-card bg-financial">
          <i class="bi bi-cash-stack service-icon"></i>
          <h4 class="fw-bold mb-2">Financial Management</h4>
          <p>Transparent accounting, detailed reports, and guidance on maximizing your rental income.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- WHY CHOOSE US -->
<section class="py-5" style="background:#f8f9fa;">
  <div class="container">
    <h2 class="text-center mb-5">Why Choose Tbil Properties?</h2>
    <div class="row g-4">
      <div class="col-md-4 text-center">
        <i class="bi bi-shield-lock service-icon"></i>
        <h5 class="fw-bold mt-2">Trusted & Reliable</h5>
        <p>We manage properties with integrity and professionalism, protecting your investment.</p>
      </div>
      <div class="col-md-4 text-center">
        <i class="bi bi-people service-icon"></i>
        <h5 class="fw-bold mt-2">Experienced Team</h5>
        <p>Our team has years of experience in managing residential and commercial properties.</p>
      </div>
      <div class="col-md-4 text-center">
        <i class="bi bi-speedometer2 service-icon"></i>
        <h5 class="fw-bold mt-2">Maximized ROI</h5>
        <p>We ensure your properties are well-maintained and generate optimal returns.</p>
      </div>
    </div>
  </div>
</section>

<!-- CTA SECTION -->
<section class="py-5 text-center">
  <div class="container">
    <h2 class="mb-4">Ready to Simplify Your Property Management?</h2>
    <a href="https://wa.link/ira501" target="_blank" class="cta-btn">
      <i class="bi bi-whatsapp"></i> Message Us Now
    </a>
  </div>
</section>
<?php
include 'footer.php';

?>