<!DOCTYPE html>
<html lang="en">
<head>
  
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tbil Properties</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    
  </style>
</head>

<body>
<!-- ================= NAVIGATION ================= -->
<nav class="navbar navbar-expand-lg" style="background-color: black;">
  <div class="container">

    <!-- YOUR ORIGINAL LOGO -->
    <a class="navbar-brand fw-bold text-white" href="#">
      <img src="assets/img/logo.png" alt="logo" style="height:45px; margin-right:10px;">
      Tbil Properties
    </a>

    <button class="navbar-toggler bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navMenu">
      <ul class="navbar-nav ms-auto">

        <li class="nav-item">
          <a class="nav-link text-white" href="#">Home</a>
        </li>

        <li class="nav-item">
          <a class="nav-link text-white" href="buy.php">Buy / Rent</a>
        </li>
         <li class="nav-item">
          <a class="nav-link text-white" href="#">Building Construction</a>
        </li>
         <li class="nav-item">
          <a class="nav-link text-white" href="#">Property Management</a>
        </li>

        <!-- DIGITAL MARKETING DROPDOWN -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" data-bs-toggle="dropdown">
            Digital Marketing Services
          </a>
          <ul class="dropdown-menu dropdown-menu-dark">
            <li><a class="dropdown-item" href="#">Social Media Ads</a></li>
            <li><a class="dropdown-item" href="#">Website Development</a></li>
            <li><a class="dropdown-item" href="#">SEO & Google Ranking</a></li>
            <li><a class="dropdown-item" href="#">Branding & Graphics</a></li>
            <li><a class="dropdown-item" href="#">Video Editing</a></li>
          </ul>
        </li>

        <!-- BOOK A FLIGHT DROPDOWN -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" data-bs-toggle="dropdown">
            Book a Flight Ticket
          </a>
          <ul class="dropdown-menu dropdown-menu-dark">
            <li><a class="dropdown-item" href="#">Local Flights</a></li>
            <li><a class="dropdown-item" href="#">International Flights</a></li>
            <li><a class="dropdown-item" href="#">Visa Assistance</a></li>
            <li><a class="dropdown-item" href="#">Travel Packages</a></li>
          </ul>
        </li>

      </ul>
    </div>
  </div>
</nav>
<!-- ===================== HERO BANNER ===================== -->
<section class="hero-section position-relative">

  <!-- VIDEO SLIDER -->
  <video class="hero-video video1" autoplay muted loop playsinline>
    <source src="assets/banner.mp4" type="video/mp4">
  </video>

  <video class="hero-video video2" autoplay muted loop playsinline>
    <source src="assets/banner2.mp4" type="video/mp4">
  </video>

  <!-- OVERLAY -->
  <div class="hero-overlay"></div>

  <!-- CONTENT -->
  <div class="hero-content container">
    <h1 class="fw-bold display-5">HELPING YOU FIND YOUR PIECE OF NIGERIA</h1>
    <p class="lead">REAL ESTATE COMPANY WITH A PURPOSE</p>

    <div class="category-tabs mt-4">
      <button class="btn btn-dark">All</button>
      <button class="btn btn-light"><a style="color:#000" href="rent.php">For Rent</a></button>
      <button class="btn btn-light"><a style="color:#000" href="buy.php">For Sale</a></button>
    </div>

    <form action="search_results.php" method="GET">
      <div class="search-box container mt-4">
        <div class="row g-3">

          <!-- Location -->
          <div class="col-md-3">
            <label class="text-white small">SEARCH</label>
            <input type="text" class="form-control" name="location" placeholder="Enter location (e.g. Lekki)">
          </div>

          <!-- Type -->
          <div class="col-md-3">
            <label class="text-white small">LOOKING FOR</label>
            <select class="form-select" name="type">
              <option value="">Property Type</option>
              <option value="sale">Buy</option>
              <option value="rent">Rent</option>
              <option value="shortlet">Shortlet</option>
            </select>
          </div>

          <!-- Bedrooms -->
          <div class="col-md-2">
            <label class="text-white small">PROPERTY SIZE</label>
            <select class="form-select" name="bedrooms">
              <option value="">Bedrooms</option>
              <option value="1">1 Bedroom</option>
              <option value="2">2 Bedrooms</option>
              <option value="3">3 Bedrooms</option>
              <option value="4">4 Bedrooms</option>
            </select>
          </div>

          <!-- Price -->
          <div class="col-md-2">
            <label class="text-white small">YOUR BUDGET</label>
            <select class="form-select" name="price_range">
              <option value="">Max. Price</option>
              <option value="0-50000000">Below ₦50M</option>
              <option value="50000000-100000000">₦50M - ₦100M</option>
              <option value="100000000-200000000">₦100M - ₦200M</option>
              <option value="200000000-1000000000">₦200M - ₦1B</option>
            </select>
          </div>

          <!-- Search Button -->
          <div class="col-md-2 d-flex align-items-end">
            <button class="btn btn-light w-100 fw-bold">Search</button>
          </div>

        </div>
      </div>
    </form>
  </div>
</section>


<style>
/* ===== HERO SECTION GENERAL ===== */
.hero-section {
  position: relative;
  height: 100vh;
  display: flex;
  align-items: center;
  color: white;
  overflow: hidden;
}

/* ===== BASE VIDEO STYLING ===== */
.hero-video {
  position: absolute;
  top: 50%;
  left: 50%;
  min-width: 100%;
  min-height: 100%;
  width: auto;
  height: auto;
  transform: translate(-50%, -50%);
  object-fit: cover;
  z-index: -2;
  opacity: 0;
}

/* ===== SLIDER ANIMATION ===== */
.video1 {
  animation: fade1 10s infinite;
}

.video2 {
  animation: fade2 10s infinite;
}

@keyframes fade1 {
  0%   { opacity: 1; }
  45%  { opacity: 1; }
  50%  { opacity: 0; }
  100% { opacity: 0; }
}

@keyframes fade2 {
  0%   { opacity: 0; }
  45%  { opacity: 0; }
  50%  { opacity: 1; }
  100% { opacity: 1; }
}

/* ===== OVERLAY ===== */
.hero-overlay {
  position: absolute;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.4);
  z-index: -1;
}

/* ===== CONTENT ===== */
.hero-content {
  position: relative;
  z-index: 5;
  text-align: center;
}

.search-box {
  background: rgba(0,0,0,0.55);
  padding: 25px;
  border-radius: 12px;
  margin-top: 40px;
}

.category-tabs button {
  border-radius: 0;
  padding: 10px 25px;
  font-weight: 600;
}
</style>

<!-- ===================== RESIDENTIAL & COMMERCIAL ===================== -->
<section class="container my-5 py-5">

    <div class="row align-items-center mb-5">
    <div class="col-md-5">
      <h2 class="fw-bold">Featured Listing</h2>
      <p>Browse through our beautiful collection of properties.</p>
    </div>

    <div class="col-md-7 d-flex gap-4">

      <div class="card border-0 shadow-sm">
        <img src="https://images.unsplash.com/photo-1568605114967-8130f3a36994?auto=format&fit=crop&w=900&q=60"
        class="card-img-top" alt="">
        <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
          <p>22 Houses</p>
          <h5>Houses for RENT</h5>
          <span><a href="rent.php"style="color:#fff">Explore Properties</a></span>
        </div>
      </div>

      <div class="card border-0 shadow-sm">
        <img src="https://images.unsplash.com/photo-1554995207-c18c203602cb?auto=format&fit=crop&w=900&q=60"
        class="card-img-top" alt="">
        <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
          <p>236 Properties</p>
          <h5>Houses (For SALE)</h5>
          <span><a href="buy.php"style="color:#fff">Explore Properties</a> </span>
        </div>
      </div>

    </div>
  </div>

  <div class="row align-items-center mb-5">
    <div class="col-md-5">
     
    </div>

    <div class="col-md-7 d-flex gap-4">
<style>
  .property-card {
    height: 250px; /* Same height as original cards */
    position: relative;
    overflow: hidden;
  }

  .property-card img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Makes image fill card without stretching */
  }

  .property-card .card-img-overlay {
    background: rgba(0,0,0,0.3); /* Optional overlay for text */
  }
</style>

<div class="card property-card border-0 shadow-sm">
  <img src="https://images.unsplash.com/photo-1599423300746-b62533397364?auto=format&fit=crop&w=900&q=60"
       class="card-img-top" alt="Lagos Property">
  <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
    <p>32 Lands posted</p>
    <h5>Lands</h5>
   <span><a href="rent.php"style="color:#fff">Explore Properties</a></span>
  </div>
</div>

<div class="card property-card border-0 shadow-sm">
  <img src="assets/img/tz1.jpg"
       class="card-img-top" alt="Abuja Property">
  <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
    <p>36 Posted</p>
    <h5>Shortlet</h5>
    <span><a href="rent.php"style="color:#fff">Explore Properties</a></span>
  </div>
</div>

    </div>
  </div>

  

</section>
<!-- ===== EXPLORE PROPERTIES: single horizontal row (drop-in) ===== -->
<style>
  .explore-row { padding: 60px 0; }
  .explore-left h2 { line-height: 1.02; font-weight: 600; }
  .explore-desc { color: #666; max-width: 360px; margin-top: 18px; }

  /* wrapper that forces a single non-wrapping horizontal row for cards */
  .props-scroll {
    display: flex;
    gap: 28px;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    padding-bottom: 6px;
    scroll-behavior: smooth;
    flex-wrap: nowrap; /* important: prevent wrapping */
  }

  /* hide default scrollbar (optional, but keep accessible) */
  .props-scroll::-webkit-scrollbar { height: 8px; }
  .props-scroll::-webkit-scrollbar-thumb { background: rgba(0,0,0,0.12); border-radius: 20px; }
  .props-scroll::-webkit-scrollbar-track { background: transparent; }

  .prop-card {
    min-width: 300px;       /* ensures equal visible width */
    height: 220px;
    border-radius: 8px;
    overflow: hidden;
    position: relative;
    box-shadow: 0 18px 30px rgba(20,20,20,0.08);
    flex: 0 0 auto;         /* keep fixed width and avoid shrinking */
    background: #000;
  }

  .prop-card img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    transition: transform .45s ease;
  }

  .prop-card:hover img { transform: scale(1.03); }

  .prop-overlay {
    position: absolute;
    inset: 0;
    background: linear-gradient(180deg, rgba(0,0,0,0.20) 0%, rgba(0,0,0,0.48) 100%);
    color: #fff;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    padding: 18px;
  }

  .prop-meta { font-size: 13px; opacity: 0.95; }
  .prop-title { font-size: 22px; font-weight: 500; margin: 6px 0 0; }
  .prop-footer {
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap: 10px;
    font-size: 13px;
    opacity: 0.95;
  }

  .more-details {
    letter-spacing: 0.6px;
    text-transform: uppercase;
    font-weight:700;
  }

  .play-circle {
    width:36px; height:36px; border-radius:50%;
    border:2px solid rgba(255,255,255,0.85);
    display:flex; align-items:center; justify-content:center;
    background: rgba(255,255,255,0.06);
  }

  /* Responsive adjustments */
  @media (max-width: 991px) {
    .explore-left { margin-bottom: 18px; text-align: left; }
    .prop-card { min-width: 260px; height: 200px; }
  }
  @media (max-width: 576px) {
    .prop-card { min-width: 240px; height: 190px; }
  }

  /* Optional left thin border like screenshot */
  .page-left-border { border-left: 6px solid #000; padding-left: 24px; }
</style>
<?php
require 'db.php'; // your database connection

// Fetch 5 most recent properties
$query = $conn->query("SELECT * FROM properties ORDER BY created_at DESC LIMIT 5");
?>

<section class="explore-row container page-left-border">
  <div class="row align-items-start">
    <!-- Left heading/description -->
    <div class="col-lg-4 col-md-5">
      <div class="explore-left">
        <h2 class="mb-2">Explore The Top<br>Featured Properties in<br>Nigeria</h2>
        <p class="explore-desc">
          These are the top world renowned areas in Nigeria offering some of the highest ROI.
        </p>
      </div>
    </div>

    <!-- Right: horizontal row of cards -->
    <div class="col-lg-8 col-md-7">
      <div class="props-scroll" role="list">
        <?php while($row = $query->fetch_assoc()): ?>
        <article class="prop-card" role="listitem" aria-label="<?= htmlspecialchars($row['title']) ?> — <?= $row['properties_count'] ?? 'N/A' ?> Properties">
          <img src="<?= htmlspecialchars($row['img']); ?>" alt="<?= htmlspecialchars($row['title']); ?>">
          <div class="prop-overlay">
            <div class="prop-meta"></div>
            <div>
              <div class="prop-title"><?= htmlspecialchars($row['title']); ?></div>
              <div class="prop-footer">
                <div class="more-details">
                  <a href="view_single_property.php?id=<?= $row['id']; ?>" style="color:white; text-decoration:none;">MORE DETAILS</a>
                </div>
                <div class="play-circle" aria-hidden="true">
                  <svg width="12" height="12" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                    <path d="M8 5v14l11-7L8 5z" fill="white"/>
                  </svg>
                </div>
              </div>
            </div>
          </div>
        </article>
        <?php endwhile; ?>
      </div>
    </div>
  </div>
</section>

<style>
/* Optional: make sure all images/cards have same size */
.prop-card {
  position: relative;
  width: 220px;
  height: 200px;
  margin-right: 15px;
  overflow: hidden;
  display: inline-block;
  border-radius: 6px;
}

.prop-card img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.prop-overlay {
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  padding: 10px;
  background: rgba(0,0,0,0.4);
  color: #fff;
}

.props-scroll {
  display: flex;
  overflow-x: auto;
  padding-bottom: 10px;
}
</style>

<section class="py-5" style="background:#ffffff;">
  <div class="container">

    <div class="text-center mb-4">
      <h2 class="fw-bold">What Are You Looking For?</h2>
      <p class="text-muted mt-2">Choose the category that fits your real estate needs.</p>
    </div>

    <style>
      .brs-card {
        padding: 35px 25px;
        border-radius: 14px;
        background: #fff;
        box-shadow: 0 10px 28px rgba(0,0,0,0.07);
        transition: all .3s ease;
        cursor: pointer;
        text-align: center;
        border: 1px solid #e8e8e8;
      }
      .brs-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 18px 40px rgba(0,0,0,0.09);
      }
      .brs-icon {
        width: 64px;
        height: 64px;
        margin: 0 auto 20px;
        border-radius: 50%;
        background: #000;
        display:flex;
        align-items:center;
        justify-content:center;
      }
      .brs-icon svg { width: 30px; height: 30px; color:white; }
    </style>

    <div class="row g-4 mt-4">

      <!-- Buy -->
      <div class="col-lg-4 col-md-4">
       
        <div class="brs-card">
          <div class="brs-icon">
            <svg fill="none" stroke="white" stroke-width="2" viewBox="0 0 24 24">
              <path d="M3 9l9-6 9 6v11a1 1 0 01-1 1h-5a1 1 0 01-1-1v-4H9v4a1 1 0 01-1 1H3z"/>
            </svg>
          </div>
          <h4 class="fw-bold mb-2">Buy a Property</h4>
          <p class="text-muted">Explore luxury homes, villas, apartments and premium communities to invest in.</p>
        </div>
      </div>

      <!-- Rent -->
      <div class="col-lg-4 col-md-4">
        <div class="brs-card">
          <div class="brs-icon">
            <svg fill="none" stroke="white" stroke-width="2" viewBox="0 0 24 24">
              <path d="M8 17v-3m4 3v-6m4 6v-9M3 21h18M3 3h18v18H3z"/>
            </svg>
          </div>
          <h4 class="fw-bold mb-2">Rent a Home</h4>
          <p class="text-muted">Find comfortable and affordable rental properties in top Dubai areas.</p>
        </div>
      </div>

      <!-- Shortlet -->
      <div class="col-lg-4 col-md-4">
        <div class="brs-card">
          <div class="brs-icon">
            <svg fill="none" stroke="white" stroke-width="2" viewBox="0 0 24 24">
              <path d="M4 4h16v16H4z"/>
              <path d="M4 10h16"/>
            </svg>
          </div>
          <h4 class="fw-bold mb-2">Shortlet Apartments</h4>
          <p class="text-muted">Book modern short-stay apartments perfect for business trips or vacations.</p>
        </div>
      </div>

    </div>
  </div>
</section>
<section class="py-5" style="background:#000;">
  <div class="container">

    <div class="text-center mb-4">
      <h2 class="fw-bold text-white">Post a Property</h2>
      <p class="text-white-50">List your property for sale, rent, or shortlet — reach thousands of buyers instantly.</p>
     <a href="registration.php" class="btn" style="background-color: white; color: black; border: 1px solid black;">Sign Up</a>
<a href="login.php" class="btn" style="background-color: black; color: white; border: 1px solid white;">Sign In</a>

    </div>

   
  </div>
</section>

<footer class="text-white pt-5 pb-4" style="background:#000;">
  <div class="container">

    <div class="row">

      <!-- Company Info -->
      <div class="col-lg-4 col-md-6 mb-4">
        <h4 class="fw-bold">Tbil Properties</h4>
        <p class="mt-3" style="line-height:1.7;">
          Your trusted partner for luxury real estate, rentals, shortlets, and premium lifestyle services across the world.
        </p>
      </div>

      <!-- Quick Links -->
      <div class="col-lg-2 col-md-6 mb-4">
        <h5 class="fw-bold mb-3">Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-white text-decoration-none">Home</a></li>
          <li><a href="#" class="text-white text-decoration-none">Buy / Rent</a></li>
          <li><a href="#" class="text-white text-decoration-none">Shortlets</a></li>
          <li><a href="#" class="text-white text-decoration-none">Digital Marketing</a></li>
        </ul>
      </div>

      <!-- Services -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="fw-bold mb-3">Our Services</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-white text-decoration-none">Real Estate Consultation</a></li>
          <li><a href="#" class="text-white text-decoration-none">Property Management</a></li>
          <li><a href="#" class="text-white text-decoration-none">Book Flight Tickets</a></li>
          <li><a href="#" class="text-white text-decoration-none">Marketing & Branding</a></li>
        </ul>
      </div>

      <!-- Contact -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="fw-bold mb-3">Contact Us</h5>
        <p class="mb-1 text-white">Email: info@tbilproperties.com</p>
        <p class="mb-1 text-white">Phone: +234 912 345 6789</p>
        <p class="text-white">Location: Lagos, Nigeria</p>

        <div class="mt-3">
          <a href="#" class="text-white me-3"><i class="bi bi-facebook"></i></a>
          <a href="#" class="text-white me-3"><i class="bi bi-instagram"></i></a>
          <a href="#" class="text-white me-3"><i class="bi bi-youtube"></i></a>
        </div>
      </div>

    </div>

    <hr class="border-light">

    <div class="text-center mt-3">
      <p class="mb-0 text-white">© 2025 Tbil Properties. All Rights Reserved.</p>
    </div>

  </div>
</footer>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
