<?php
include 'navbar.php';
require 'db.php';

// Get property ID
if(!isset($_GET['id']) || empty($_GET['id'])){
    die("Invalid property ID");
}
$id = intval($_GET['id']);

// Fetch main property
$stmt = $conn->prepare("SELECT * FROM properties WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
if($result->num_rows < 1) die("Property not found.");
$property = $result->fetch_assoc();
$stmt->close();

// Fetch additional property images
$images_stmt = $conn->prepare("SELECT image_path FROM property_images WHERE property_id = ?");
$images_stmt->bind_param("i", $id);
$images_stmt->execute();
$images_result = $images_stmt->get_result();
$gallery_images = [$property['img']]; // Include main image first
while($row = $images_result->fetch_assoc()){
    $gallery_images[] = $row['image_path'];
}
$images_stmt->close();

// Fetch agent info from users table
$agent_stmt = $conn->prepare("SELECT fullname, phoneno, email FROM users WHERE id = ?");
$agent_stmt->bind_param("i", $property['user_id']);
$agent_stmt->execute();
$agent_result = $agent_stmt->get_result();
$agent = $agent_result->fetch_assoc();
$agent_stmt->close();
?>

<!DOCTYPE html>

<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($property['title']); ?> | Tbil Properties</title>
<link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
<link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">
<link href="assets/css/main.css" rel="stylesheet">
</head>
<body>

<section id="property-details" class="property-details section">
  <div class="container">
    <div class="row">
      <!-- Left: Gallery & Info -->
      <div class="col-lg-7">
        <!-- Property Hero / Gallery -->
        <div class="property-hero mb-5">
          <div class="hero-image-container">
            <div class="property-gallery-slider swiper">
              <div class="swiper-wrapper">
                <?php foreach($gallery_images as $img): ?>
                <div class="swiper-slide">
                  <img src="<?= htmlspecialchars($img); ?>" class="img-fluid hero-image" alt="Property Image">
                </div>
                <?php endforeach; ?>
              </div>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
            </div>
          </div>
          <!-- Thumbnail Gallery -->
          <div class="thumbnail-gallery mt-3">
            <div class="property-thumbnails-slider swiper">
              <div class="swiper-wrapper">
                <?php foreach($gallery_images as $img): ?>
                <div class="swiper-slide">
                  <img src="<?= htmlspecialchars($img); ?>" class="img-fluid thumbnail-img" alt="Thumbnail">
                </div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
        </div>

```
    <!-- Property Information -->
    <div class="property-info mb-5">
      <div class="property-header">
        <h1 class="property-title"><?= htmlspecialchars($property['title']); ?></h1>
        <div class="property-meta">
          <span class="address"><i class="bi bi-geo-alt"></i> <?= htmlspecialchars($property['location']); ?></span>
          <span class="listing-id">ID: #<?= $property['id']; ?></span>
        </div>
      </div>
      <div class="pricing-section"style="background-color:#000">
        <div class="main-price">₦<?= number_format($property['price']); ?></div>
        <div class="price-breakdown">
          <span class="available">Status: <?= htmlspecialchars($property['status']); ?></span>
        </div>
      </div>
      <!-- Quick Stats -->
      <div class="quick-stats mt-3">
        <div class="row g-3">
          <div class="col-4 text-center">
            <i class="bi bi-house"></i>
            <div><?= $property['bedrooms'] ?? '-' ?> Beds</div>
          </div>
          <div class="col-4 text-center">
            <i class="bi bi-droplet"></i>
            <div><?= $property['bathrooms'] ?? '-' ?> Baths</div>
          </div>
          <div class="col-4 text-center">
            <i class="bi bi-arrows-angle-expand"></i>
            <div><?= $property['area'] ?? '-' ?> Sq Ft</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Property Description -->
    <div class="property-details mb-5">
      <h3>Property Description</h3>
      <p><?= nl2br(htmlspecialchars($property['description'])); ?></p>
    </div>
  </div>

  <!-- Right Sidebar: Agent & Contact -->
  <div class="col-lg-5">
    <div class="sticky-sidebar">
    <!-- Contact / Agent Card Replacement -->

<div class="agent-card mb-4 text-center">
  <div class="agent-header">
    <div class="agent-info">
      <h4>Connect with the Seller / Agent</h4>
      <p class="mb-2">Interested in this property? Send us a message or contact us on WhatsApp to get in touch with the seller, agent, or renter.</p>
      <a href="https://wa.link/ira501" target="_blank" class="btn btn-success">
        <i class="bi bi-whatsapp"></i> Message on WhatsApp
      </a>
    </div>
  </div>
</div>


      <!-- Request Information Form -->
      <div class="contact-form-card mb-4">
        <h4>Contact Us</h4>
        <form action="forms/contact.php" method="post" class="php-email-form">
          <input type="text" name="name" class="form-control mb-2" placeholder="Full Name" required>
          <input type="email" name="email" class="form-control mb-2" placeholder="Email" required>
          <textarea name="message" class="form-control mb-2" rows="3" placeholder="Your Message"></textarea>
          <button type="submit" class="btn btn-primary w-100">Send Request</button>
        </form>
      </div>
    </div>
  </div>
</div>
```

  </div>
</section>

<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

<script>
const mainGallery = new Swiper('.property-gallery-slider', {
  loop: true,
  speed: 600,
  navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev' },
  thumbs: { swiper: { el: '.property-thumbnails-slider', slidesPerView: 4, spaceBetween: 10 } },
});
const thumbsGallery = new Swiper('.property-thumbnails-slider', {
  loop: true,
  spaceBetween: 10,
  slidesPerView: 4,
  freeMode: true,
  watchSlidesProgress: true,
});
mainGallery.thumbs.swiper = thumbsGallery;
</script>

<?php
include 'footer.php';

?>