<?php
include 'dashboard.php';
if (!isset($_SESSION['user_id'])) header("Location: login.php");
require 'db.php';

// Fetch logged-in user properties
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM properties WHERE agent_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
<title>My Properties</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
<div class="container mt-5">
    <h3 class="mb-4">My Properties</h3>

    <div class="row">
        <?php while($row = $result->fetch_assoc()): ?>
        <div class="col-md-4 mb-4">
            <div class="card shadow-sm">
                <img src="<?= $row['img']; ?>" class="card-img-top" style="height:220px; object-fit:cover;">
                <div class="card-body">
                    <h5 class="card-title"><?= htmlspecialchars($row['title']); ?></h5>
                    <p class="card-text"><?= substr($row['description'], 0, 80); ?>...</p>
                    <p class="fw-bold">₦<?= number_format($row['price']); ?></p>
                    <span class="badge bg-primary text-uppercase"><?= $row['type']; ?></span>
                    <p class="text-muted"><?= $row['location']; ?></p>

                    <a href="edit_property.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                    <a href="delete_property.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-danger">Delete</a>
                </div>
            </div>
        </div>
        <?php endwhile; ?>
    </div>
</div>
</body>
</html>
