<?php
include 'navbar.php';
require 'db.php';


// ----------------------
// SEARCH FILTER LOGIC
// ----------------------
$where = " WHERE 1 ";

if (!empty($_GET['keyword'])) {
    $keyword = "%".$_GET['keyword']."%";
    $where .= " AND (title LIKE '$keyword' OR location LIKE '$keyword')";
}

if (!empty($_GET['type'])) {
    $type = $_GET['type'];
    $where .= " AND type = '$type'";
}

if (!empty($_GET['min_price'])) {
    $min = intval($_GET['min_price']);
    $where .= " AND price >= $min";
}

if (!empty($_GET['max_price'])) {
    $max = intval($_GET['max_price']);
    $where .= " AND price <= $max";
}


// ----------------------
// PAGINATION
// ----------------------
$limit = 6;  // properties per page
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$start = ($page - 1) * $limit;

// Get total rows
$totalQuery = $conn->query("SELECT COUNT(*) AS total FROM properties $where");
$totalRows = $totalQuery->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);

// Fetch paginated result
$query = $conn->query("SELECT * FROM properties $where ORDER BY created_at DESC");

?>

<!DOCTYPE html>
<html>
<head>
<title>All Properties</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
<div class="container mt-5">

    <h3 class="mb-4">All Properties</h3>

    <!-- SEARCH FILTERS -->
    <form class="row mb-4" method="GET">
        <div class="col-md-3 mb-2">
            <input type="text" name="keyword" class="form-control" placeholder="Search by title or location" value="<?= $_GET['keyword'] ?? '' ?>">
        </div>

        <div class="col-md-2 mb-2">
            <select name="type" class="form-control">
                <option value="">Property Type</option>
                <option value="rent" <?= (($_GET['type'] ?? '') == 'rent') ? 'selected' : '' ?>>Rent</option>
                <option value="sale" <?= (($_GET['type'] ?? '') == 'sale') ? 'selected' : '' ?>>Sale</option>
            </select>
        </div>

        <div class="col-md-2 mb-2">
            <input type="number" name="min_price" class="form-control" placeholder="Min Price" value="<?= $_GET['min_price'] ?? '' ?>">
        </div>

        <div class="col-md-2 mb-2">
            <input type="number" name="max_price" class="form-control" placeholder="Max Price" value="<?= $_GET['max_price'] ?? '' ?>">
        </div>

        <div class="col-md-2 mb-2">
            <button class="btn btn-primary w-100">Search</button>
        </div>
    </form>



    <!-- PROPERTY CARDS -->
    <div class="row">
        <?php while($row = $query->fetch_assoc()): ?>

        <div class="col-md-4 mb-4">
            <div class="card shadow-sm">
                
                <img src="<?= $row['img']; ?>" class="card-img-top" style="height:230px; object-fit:cover;">

                <div class="card-body">

                    <h5 class="card-title"><?= htmlspecialchars($row['title']); ?></h5>

                    <!-- TYPE BADGE -->
                    <span class="badge bg-primary text-uppercase"><?= $row['type']; ?></span>

                    <!-- STATUS BADGE -->
                    <?php if($row['status'] == 'available'): ?>
                        <span class="badge bg-success">Available</span>
                    <?php else: ?>
                        <span class="badge bg-danger">Sold</span>
                    <?php endif; ?>

                    <p class="fw-bold mt-2">₦<?= number_format($row['price']); ?></p>
                    <p class="text-muted mb-1"><?= $row['location']; ?></p>

                    <p><?= substr($row['description'], 0, 60); ?>...</p>

                    <a href="view_single_property.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-primary">View</a>

                </div>
            </div>
        </div>

        <?php endwhile; ?>
    </div>


    <!-- PAGINATION LINKS -->
    <nav aria-label="Page navigation" class="mt-4">
        <ul class="pagination">

            <!-- Prev -->
            <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page-1 ?>&<?= http_build_query($_GET); ?>">Previous</a>
            </li>

            <!-- Page Numbers -->
            <?php for($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=<?= $i ?>&<?= http_build_query($_GET); ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>

            <!-- Next -->
            <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                <a class="page-link" href="?page=<?= $page+1 ?>&<?= http_build_query($_GET); ?>">Next</a>
            </li>

        </ul>
    </nav>

</div>
<?php
include 'footer.php';

?>