<?php 


include 'navbar.php';
require 'db.php';

// Fetch latest 6 properties for sale
$latestSale = $conn->query("SELECT * FROM properties WHERE type='sale' ORDER BY created_at DESC LIMIT 6");
?>

<section class="hero-section position-relative">

  <!-- VIDEO SLIDER -->
  <video class="hero-video video1" autoplay muted loop playsinline>
    <source src="assets/banner.mp4" type="video/mp4">
  </video>

  <video class="hero-video video2" autoplay muted loop playsinline>
    <source src="assets/banner2.mp4" type="video/mp4">
  </video>

  <!-- OVERLAY -->
  <div class="hero-overlay"></div>

  <!-- CONTENT -->
  <div class="hero-content container">
    <h1 class="fw-bold display-6">HELPING YOU FIND YOUR NEXT PIECE OF PROPERTY</h1>
    <p class="lead">REAL ESTATE COMPANY WITH A PURPOSE</p>
<!-- SERVICES STRIP ON BANNER -->
 <div class="services-strip text-white py-2" 
     style="
       backdrop-filter: blur(6px);
       border-radius: 12px;margin-top:140px;">
  <div class="container">
    <div class="d-flex flex-wrap justify-content-center gap-2">

      <!-- Flight Booking -->
      <div class="service-item d-flex flex-column align-items-center p-2 rounded-3"
           style="background: rgba(255,255,255,0.1); border:1px solid rgba(255,255,255,0.15); min-width:80px;">
        <i class="bi bi-airplane-fill fs-3 mb-1"></i>
        <small<a  href="">Flights</a></small>
      </div>

      

      <!-- Visa -->
      <div class="service-item d-flex flex-column align-items-center p-2 rounded-3"
           style="background: rgba(255,255,255,0.1); border:1px solid rgba(255,255,255,0.15); min-width:80px;">
        <i class="bi bi-credit-card-2-front fs-3 mb-1"></i>
        <small>Visa</small>
      </div>


      <!-- Digital -->
      <div class="service-item d-flex flex-column align-items-center p-2 rounded-3"
           style="background: rgba(255,255,255,0.1); border:1px solid rgba(255,255,255,0.15); min-width:80px;">
        <i class="bi bi-laptop-fill fs-3 mb-1"></i>
        <small>Digital</small>
      </div>

      <!-- Study Abroad -->
      <div class="service-item d-flex flex-column align-items-center p-2 rounded-3"
           style="background: rgba(255,255,255,0.1); border:1px solid rgba(255,255,255,0.15); min-width:80px;">
        <i class="bi bi-globe2 fs-3 mb-1"></i>
        <small>Study Abroad</small>
      </div>

    </div>
  </div>
</div>

<style>
  .feature-card img {
    width: 100%;
    height: 250px; /* Adjust to your preferred uniform height */
    object-fit: cover;
  }
  .feature-card {
    width: 100%;
    overflow: hidden;
    border-radius: 10px;
  }
  </style>
    <div class="category-tabs mt-4">
      <button class="btn btn-dark">All</button>
      <button class="btn btn-light"><a style="color:#000" href="rent.php">For Rent</a></button>
      <button class="btn btn-light"><a style="color:#000" href="buy.php">For Sale</a></button>
    </div>

    <form action="search_results.php" method="GET">
      <div class="search-box container mt-4">
        <div class="row g-3">

          <!-- Location -->
          <div class="col-md-3">
            <label class="text-white small">SEARCH</label>
            <input type="text" class="form-control" name="location" placeholder="Enter location (e.g. Lekki)">
          </div>

          <!-- Type -->
          <div class="col-md-3">
            <label class="text-white small">LOOKING FOR</label>
            <select class="form-select" name="type">
              <option value="">Property Type</option>
              <option value="sale">Buy</option>
              <option value="rent">Rent</option>
              <option value="shortlet">Shortlet</option>
            </select>
          </div>

          <!-- Bedrooms -->
          <div class="col-md-2">
            <label class="text-white small">PROPERTY SIZE</label>
            <select class="form-select" name="bedrooms">
              <option value="">Bedrooms</option>
              <option value="1">1 Bedroom</option>
              <option value="2">2 Bedrooms</option>
              <option value="3">3 Bedrooms</option>
              <option value="4">4 Bedrooms</option>
            </select>
          </div>

          <!-- Price -->
          <div class="col-md-2">
            <label class="text-white small">YOUR BUDGET</label>
            <select class="form-select" name="price_range">
              <option value="">Max. Price</option>
              <option value="0-50000000">Below ₦50M</option>
              <option value="50000000-100000000">₦50M - ₦100M</option>
              <option value="100000000-200000000">₦100M - ₦200M</option>
              <option value="200000000-1000000000">₦200M - ₦1B</option>
            </select>
          </div>

          <!-- Search Button -->
          <div class="col-md-2 d-flex align-items-end">
            <button class="btn btn-light w-100 fw-bold">Search</button>
          </div>

        </div>
      </div>
    </form>
  </div>
</section>

<style>
</style>

<!-- ===================== LATEST PROPERTIES FOR SALE ===================== -->
<section class="container my-5">
 <div class="text-center">
  <h2 class="fw-bold mb-3">Properties For Sale</h2>
  <p class="text-muted">Below is a list of properties that are currently up for sale</p>
</div>

  <div class="row g-4">

    <?php while($row = $latestSale->fetch_assoc()): ?>
      <div class="col-md-4 col-sm-6">
        <div class="card shadow-sm border-0">

          <img src="<?= htmlspecialchars($row['img']); ?>" 
               class="card-img-top" 
               alt="<?= htmlspecialchars($row['title']); ?>" 
               style="height:200px; object-fit:cover;">

          <div class="card-body">
            <h5 class="card-title fw-bold"><?= htmlspecialchars($row['title']); ?></h5>
            <p class="price text-dark">₦<?= number_format($row['price']); ?></p>
            <p class="text-muted small"><?= htmlspecialchars($row['location']); ?></p>

            <a href="view_single_property.php?id=<?= $row['id']; ?>" 
               class="btn btn-dark w-100">View Details</a>
          </div>

        </div>
      </div>
    <?php endwhile; ?>

  </div>

  <div class="text-center mt-4">
    <a href="buy.php" class="btn btn-outline-dark px-4 py-2">View All Properties for Sale</a>
  </div>
</section>

<style>
  .feature-card img {
    width: 100%;
    height: 250px; /* Adjust to your preferred uniform height */
    object-fit: cover;
  }
  .feature-card {
    width: 100%;
    overflow: hidden;
    border-radius: 10px;
  }
</style>

<!-- ===================== RESIDENTIAL & COMMERCIAL ===================== -->
<section class="container my-5 py-5">

  <div class="row align-items-center mb-5">
    <div class="col-md-5">
      <h2 class="fw-bold">Featured Listing</h2>
      <p>Browse through our beautiful collection of properties.</p>
      <span><a href="user_view_all_properties.php" style="color:#000">View All Available Properties</a></span>
    </div>

    <div class="col-md-7 d-flex gap-4">

      <div class="card feature-card border-0 shadow-sm">
        <img src="assets/img/house4.jpg" class="card-img-top" alt="">
        <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
          <p>22 Houses</p>
          <h5>Houses for RENT</h5>
          <span><a href="rent.php" style="color:#fff">Explore Properties</a></span>
        </div>
      </div>

      <div class="card feature-card border-0 shadow-sm">
        <img src="assets/img/house1.jpg" class="card-img-top" alt="">
        <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
          <p >236 Properties</p>
          <h5>Houses (For SALE)</h5>
          <span><a href="buy.php" style="color:#fff">Explore Properties</a></span>
        </div>
      </div>

    </div>
  </div>

  <div class="row align-items-center mb-5">
    <div class="col-md-5"></div>

    <div class="col-md-7 d-flex gap-4">

      <div class="card feature-card border-0 shadow-sm">
        <img src="assets/img/land.webp" class="card-img-top" alt="">
        <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
          <p>32 Lands posted</p>
          <h5>Lands</h5>
          <span><a href="rent.php" style="color:#fff">Explore Properties</a></span>
        </div>
      </div>

      <div class="card feature-card border-0 shadow-sm">
        <img src="assets/img/apartment.webp" class="card-img-top" alt="">
        <div class="card-img-overlay text-white d-flex flex-column justify-content-end">
          <p>36 Posted</p>
          <h5>Shortlet</h5>
          <span><a href="rent.php" style="color:#fff">Explore Properties</a></span>
        </div>
      </div>

    </div>
  </div>

</section>

<!-- ===================== RENT SECTION ===================== -->
<!-- ===================== RENT SECTION ===================== -->

<div class="container mb-4 mt-5">
  <h2 class="fw-bold text-center mb-3">Properties Available for Rent</h2>
  <p class="text-center text-muted">Browse our latest rental listings across Nigeria.</p>
</div>

<div class="container">
  <div class="row g-4">

    <?php
      $query = $conn->query("SELECT * FROM properties WHERE type='rent' ORDER BY created_at DESC");

      while($row = $query->fetch_assoc()):
    ?>
    
      <div class="col-md-4 col-sm-6">
        <div class="card card-property shadow-sm">
          <img src="<?= htmlspecialchars($row['img']); ?>" 
               class="card-img-top" 
               alt="<?= htmlspecialchars($row['title']); ?>"
               style="width:100%; height:250px; object-fit:cover;">

          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($row['title']); ?></h5>

            <p class="price">₦<?= number_format($row['price']); ?> / month</p>

            <p class="text-muted"><?= htmlspecialchars($row['location']); ?></p>

            <a href="view_single_property.php?id=<?= $row['id']; ?>"
               class="btn w-100"
               style="background-color:#000; color:#fff;">
               View Details
            </a>
          </div>
        </div>
      </div>

    <?php endwhile; ?>

  </div>
</div>



<!-- ===== EXPLORE PROPERTIES: single horizontal row (drop-in) ===== -->
<style>
  .explore-row { padding: 60px 0; }
  .explore-left h2 { line-height: 1.02; font-weight: 600; }
  .explore-desc { color: #666; max-width: 360px; margin-top: 18px; }

  /* wrapper that forces a single non-wrapping horizontal row for cards */
  .props-scroll {
    display: flex;
    gap: 28px;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    padding-bottom: 6px;
    scroll-behavior: smooth;
    flex-wrap: nowrap; /* important: prevent wrapping */
  }

  /* hide default scrollbar (optional, but keep accessible) */
  .props-scroll::-webkit-scrollbar { height: 8px; }
  .props-scroll::-webkit-scrollbar-thumb { background: rgba(0,0,0,0.12); border-radius: 20px; }
  .props-scroll::-webkit-scrollbar-track { background: transparent; }

  .prop-card {
    min-width: 300px;       /* ensures equal visible width */
    height: 220px;
    border-radius: 8px;
    overflow: hidden;
    position: relative;
    box-shadow: 0 18px 30px rgba(20,20,20,0.08);
    flex: 0 0 auto;         /* keep fixed width and avoid shrinking */
    background: #000;
  }

  .prop-card img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    transition: transform .45s ease;
  }

  .prop-card:hover img { transform: scale(1.03); }

  .prop-overlay {
    position: absolute;
    inset: 0;
    background: linear-gradient(180deg, rgba(0,0,0,0.20) 0%, rgba(0,0,0,0.48) 100%);
    color: #fff;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    padding: 18px;
  }

  .prop-meta { font-size: 13px; opacity: 0.95; }
  .prop-title { font-size: 22px; font-weight: 500; margin: 6px 0 0; }
  .prop-footer {
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap: 10px;
    font-size: 13px;
    opacity: 0.95;
  }

  .more-details {
    letter-spacing: 0.6px;
    text-transform: uppercase;
    font-weight:700;
  }

  .play-circle {
    width:36px; height:36px; border-radius:50%;
    border:2px solid rgba(255,255,255,0.85);
    display:flex; align-items:center; justify-content:center;
    background: rgba(255,255,255,0.06);
  }

  /* Responsive adjustments */
  @media (max-width: 991px) {
    .explore-left { margin-bottom: 18px; text-align: left; }
    .prop-card { min-width: 260px; height: 200px; }
  }
  @media (max-width: 576px) {
    .prop-card { min-width: 240px; height: 190px; }
  }

   .property-card {
    height: 250px; /* Same height as original cards */
    position: relative;
    overflow: hidden;
  }

  .property-card img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Makes image fill card without stretching */
  }

  .property-card .card-img-overlay {
    background: rgba(0,0,0,0.3); /* Optional overlay for text */
  }

/* ===== HERO SECTION GENERAL ===== */
.hero-section {
  position: relative;
  height: 100vh;
  display: flex;
  align-items: center;
  color: white;
  overflow: hidden;
}

/* ===== BASE VIDEO STYLING ===== */
.hero-video {
  position: absolute;
  top: 50%;
  left: 50%;
  min-width: 100%;
  min-height: 100%;
  width: auto;
  height: auto;
  transform: translate(-50%, -50%);
  object-fit: cover;
  z-index: -2;
  opacity: 0;
}

/* ===== SLIDER ANIMATION ===== */
.video1 {
  animation: fade1 10s infinite;
}

.video2 {
  animation: fade2 10s infinite;
}

@keyframes fade1 {
  0%   { opacity: 1; }
  45%  { opacity: 1; }
  50%  { opacity: 0; }
  100% { opacity: 0; }
}

@keyframes fade2 {
  0%   { opacity: 0; }
  45%  { opacity: 0; }
  50%  { opacity: 1; }
  100% { opacity: 1; }
}

/* ===== OVERLAY ===== */
.hero-overlay {
  position: absolute;
  top: 0; left: 0;
  width: 100%; height: 100%;
  background: rgba(0,0,0,0.4);
  z-index: -1;
}

/* ===== CONTENT ===== */
.hero-content {
  position: relative;
  z-index: 5;
  text-align: center;
}

.search-box {
  background: rgba(0,0,0,0.55);
  padding: 25px;
  border-radius: 12px;
  margin-top: 40px;
}

.category-tabs button {
  border-radius: 0;
  padding: 10px 25px;
  font-weight: 600;
}
  /* Optional left thin border like screenshot */
  .page-left-border { border-left: 6px solid #000; padding-left: 24px; }
  /* Optional: make sure all images/cards have same size */
.prop-card {
  position: relative;
  width: 220px;
  height: 200px;
  margin-right: 15px;
  overflow: hidden;
  display: inline-block;
  border-radius: 6px;
}

.prop-card img {
  width: 100%;
  height: 100%;
  object-fit: cover;
}

.prop-overlay {
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  padding: 10px;
  background: rgba(0,0,0,0.4);
  color: #fff;
}

.props-scroll {
  display: flex;
  overflow-x: auto;
  padding-bottom: 10px;
}
      .brs-card {
        padding: 35px 25px;
        border-radius: 14px;
        background: #fff;
        box-shadow: 0 10px 28px rgba(0,0,0,0.07);
        transition: all .3s ease;
        cursor: pointer;
        text-align: center;
        border: 1px solid #e8e8e8;
      }
      .brs-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 18px 40px rgba(0,0,0,0.09);
      }
      /* =======================================
   GLOBAL MOBILE RESPONSIVENESS
======================================= */

img {
  max-width: 100%;
  height: auto;
}

/* =======================================
   HERO SECTION RESPONSIVE
======================================= */

@media (max-width: 991px) {

  .hero-section {
    height: 85vh;
    padding-top: 40px;
  }

  .hero-content h1 {
    font-size: 26px !important;
  }

  .hero-content p {
    font-size: 15px;
  }

  .search-box {
    padding: 15px !important;
  }

  .search-box .row > div {
    margin-bottom: 10px;
  }

  .category-tabs button {
    padding: 8px 16px !important;
  }

  .hero-video {
    object-fit: cover;
    min-height: 100%;
    min-width: 100%;
  }
}

@media (max-width: 600px) {

  .hero-section {
    height: 70vh;
  }

  .hero-content h1 {
    font-size: 22px !important;
    line-height: 1.3;
  }

  .search-box {
    padding: 12px !important;
    border-radius: 8px;
  }

  .category-tabs button {
    font-size: 14px;
    padding: 6px 14px;
  }
}

/* =======================================
   PROPERTY CARDS RESPONSIVE
======================================= */

@media (max-width: 991px) {
  .card-img-top {
    height: 180px !important;
    object-fit: cover;
  }
}

@media (max-width: 768px) {
  .card-img-top {
    height: 160px !important;
  }

  .card-title {
    font-size: 16px;
  }
}

@media (max-width: 576px) {
  .col-sm-6 {
    width: 100%;
  }

  .card-property img,
  .card-img-top {
    height: 150px !important;
  }
}

/* =======================================
   FEATURED LISTING SECTION
======================================= */

@media (max-width: 991px) {
  .row.align-items-center.mb-5 {
    flex-direction: column;
    text-align: center;
  }

  .row.align-items-center.mb-5 .col-md-5 {
    margin-bottom: 20px;
  }

  .col-md-7.d-flex {
    flex-direction: column;
    gap: 20px !important;
  }

  .col-md-7 .card {
    width: 100%;
  }
}

/* =======================================
   LAND / SHORTLET CARDS RESPONSIVE
======================================= */

@media (max-width: 768px) {
  .property-card {
    height: 200px !important;
  }
}

@media (max-width: 500px) {
  .property-card {
    height: 170px !important;
  }
}

/* =======================================
   HORIZONTAL SCROLL CARDS RESPONSIVE
======================================= */

@media (max-width: 991px) {
  .explore-row {
    padding: 30px 0 !important;
  }

  .explore-left {
    text-align: center;
    margin-bottom: 20px;
  }
}

@media (max-width: 768px) {
  .prop-card {
    min-width: 220px !important;
    height: 170px !important;
  }
}

@media (max-width: 576px) {
  .prop-card {
    min-width: 200px !important;
    height: 150px !important;
  }
}

/* =======================================
   RENT SECTION RESPONSIVE
======================================= */

@media (max-width: 768px) {
  .price {
    font-size: 16px;
  }
}

@media (max-width: 576px) {
  .card-property img {
    height: 150px !important;
  }
}

/* =======================================
   WHAT ARE YOU LOOKING FOR SECTION
======================================= */

@media (max-width: 768px) {
  .brs-card {
    padding: 25px 18px !important;
  }
}

@media (max-width: 576px) {
  .brs-card {
    margin-bottom: 15px;
  }
}

/* =======================================
   GENERAL SPACING OPTIMIZATION
======================================= */

@media (max-width: 576px) {
  section.container,
  .container {
    padding-left: 12px !important;
    padding-right: 12px !important;
  }

  h2 {
    font-size: 20px !important;
  }

  p {
    font-size: 14px !important;
  }
}

      .brs-icon {
        width: 64px;
        height: 64px;
        margin: 0 auto 20px;
        border-radius: 50%;
        background: #000;
        display:flex;
        align-items:center;
        justify-content:center;
      }
      .brs-icon svg { width: 30px; height: 30px; color:white; }
</style>

<section class="py-5" style="background:#ffffff;">
  <div class="container">

    <div class="text-center mb-4">
      <h2 class="fw-bold">What Are You Looking For?</h2>
      <p class="text-muted mt-2">Choose the category that fits your real estate needs.</p>
    </div>

    <style>

</style>
<?php
require 'db.php'; // your database connection

// Fetch 5 most recent properties
$query = $conn->query("SELECT * FROM properties ORDER BY created_at DESC LIMIT 5");
?>

<section class="explore-row container page-left-border">
  <div class="row align-items-start">
    <!-- Left heading/description -->
    <div class="col-lg-4 col-md-5">
      <div class="explore-left">
        <h2 class="mb-2">Explore The Top<br>Featured Properties in<br>Nigeria</h2>
        <p class="explore-desc">
          These are the top world renowned areas in Nigeria offering some of the highest ROI.
        </p>
      </div>
    </div>

    <!-- Right: horizontal row of cards -->
    <div class="col-lg-8 col-md-7">
      <div class="props-scroll" role="list">
        <?php while($row = $query->fetch_assoc()): ?>
        <a href="view_single_property.php?id=<?= $row['id']; ?>" class="prop-card-link" style="text-decoration:none;">
          <article class="prop-card" role="listitem" aria-label="<?= htmlspecialchars($row['title']) ?> — <?= $row['properties_count'] ?? 'N/A' ?> Properties">
            <img src="<?= htmlspecialchars($row['img']); ?>" alt="<?= htmlspecialchars($row['title']) ?>">
            <div class="prop-overlay">
              <div class="prop-meta"></div>
              <div>
                <div class="prop-title"><?= htmlspecialchars($row['title']); ?></div>
                <div class="prop-footer">
                  <div class="more-details">
                    <span style="color:white; text-decoration:none;">MORE DETAILS</span>
                  </div>
                  <div class="play-circle" aria-hidden="true">
                    <svg width="12" height="12" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                      <path d="M8 5v14l11-7L8 5z" fill="white"/>
                    </svg>
                  </div>
                </div>
              </div>
            </div>
          </article>
        </a>
        <?php endwhile; ?>
      </div>
    </div>
  </div>
</section>


<style>

    </style>

    <div class="row g-4 mt-4">

      <!-- Buy -->
      <div class="col-lg-4 col-md-4">
       
        <div class="brs-card">
          <div class="brs-icon">
            <svg fill="none" stroke="white" stroke-width="2" viewBox="0 0 24 24">
              <path d="M3 9l9-6 9 6v11a1 1 0 01-1 1h-5a1 1 0 01-1-1v-4H9v4a1 1 0 01-1 1H3z"/>
            </svg>
          </div>
          <h4 class="fw-bold mb-2">Buy a Property</h4>
          <p class="text-muted">Explore luxury homes, villas, apartments and premium communities to invest in.</p>
        </div>
      </div>

      <!-- Rent -->
      <div class="col-lg-4 col-md-4">
        <div class="brs-card">
          <div class="brs-icon">
            <svg fill="none" stroke="white" stroke-width="2" viewBox="0 0 24 24">
              <path d="M8 17v-3m4 3v-6m4 6v-9M3 21h18M3 3h18v18H3z"/>
            </svg>
          </div>
          <h4 class="fw-bold mb-2">Rent a Home</h4>
          <p class="text-muted">Find comfortable and affordable rental properties in top Dubai areas.</p>
        </div>
      </div>

      <!-- Shortlet -->
      <div class="col-lg-4 col-md-4">
        <div class="brs-card">
          <div class="brs-icon">
            <svg fill="none" stroke="white" stroke-width="2" viewBox="0 0 24 24">
              <path d="M4 4h16v16H4z"/>
              <path d="M4 10h16"/>
            </svg>
          </div>
          <h4 class="fw-bold mb-2">Shortlet Apartments</h4>
          <p class="text-muted">Book modern short-stay apartments perfect for business trips or vacations.</p>
        </div>
      </div>

    </div>
  </div>
</section>
<section class="py-5" style="background:#000;">
  <div class="container">

    <div class="text-center mb-4">
      <h2 class="fw-bold text-white">Post a Property</h2>
      <p class="text-white-50">List your property for sale, rent, or shortlet — reach thousands of buyers instantly.</p>
     <a href="registration.php" class="btn" style="background-color: white; color: black; border: 1px solid black;">Sign Up</a>
<a href="login.php" class="btn" style="background-color: black; color: white; border: 1px solid white;">Sign In</a>

    </div>

   
  </div>
</section>

<footer class="text-white pt-5 pb-4" style="background:#000;">
  <div class="container">

    <div class="row">

      <!-- Company Info -->
      <div class="col-lg-4 col-md-6 mb-4">
        <h4 class="fw-bold">Tbil Properties</h4>
        <p class="mt-3" style="line-height:1.7;">
          Your trusted partner for luxury real estate, rentals, shortlets, and premium lifestyle services across the world.
        </p>
      </div>

      <!-- Quick Links -->
      <div class="col-lg-2 col-md-6 mb-4">
        <h5 class="fw-bold mb-3">Quick Links</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-white text-decoration-none">Home</a></li>
          <li><a href="#" class="text-white text-decoration-none">Buy / Rent</a></li>
          <li><a href="#" class="text-white text-decoration-none">Shortlets</a></li>
          <li><a href="#" class="text-white text-decoration-none">Digital Marketing</a></li>
        </ul>
      </div>

      <!-- Services -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="fw-bold mb-3">Our Services</h5>
        <ul class="list-unstyled">
          <li><a href="#" class="text-white text-decoration-none">Real Estate Consultation</a></li>
          <li><a href="#" class="text-white text-decoration-none">Property Management</a></li>
          <li><a href="#" class="text-white text-decoration-none">Book Flight Tickets</a></li>
          <li><a href="#" class="text-white text-decoration-none">Marketing & Branding</a></li>
        </ul>
      </div>

      <!-- Contact -->
      <div class="col-lg-3 col-md-6 mb-4">
        <h5 class="fw-bold mb-3">Contact Us</h5>
        <p class="mb-1 text-white">Email: info@tbilproperties.com</p>
        <p class="mb-1 text-white">Phone: +234 912 345 6789</p>
        <p class="text-white">Location: Lagos, Nigeria</p>

        <div class="mt-3">
          <a href="#" class="text-white me-3"><i class="bi bi-facebook"></i></a>
          <a href="#" class="text-white me-3"><i class="bi bi-instagram"></i></a>
          <a href="#" class="text-white me-3"><i class="bi bi-youtube"></i></a>
        </div>
      </div>

    </div>

    <hr class="border-light">

    <div class="text-center mt-3">
      <p class="mb-0 text-white">© 2025 Tbil Properties. All Rights Reserved.</p>
    </div>

  </div>
</footer>
<!-- POPUP OVERLAY -->
<div id="subscribePopup" class="popup-overlay">
  <div class="popup-box">
    <span class="close-popup" onclick="closePopup()">&times;</span>

    <h2 class="popup-title">Stay Updated!</h2>
    <p class="popup-text">
      Want to get notified whenever a new property is posted?<br>
      Enter your details below.
    </p>

    <form action="save_subscription.php" method="POST">
      <input type="email" name="email" class="popup-input" placeholder="Enter your email" required>
      <input type="tel" name="phone" class="popup-input" placeholder="Enter your phone number" required>

      <button type="submit" class="popup-btn">Notify Me</button>
    </form>
  </div>
</div>

<style>
/* Overlay */
.popup-overlay {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0,0,0,0.7);
  display: none;
  justify-content: center;
  align-items: center;
  z-index: 99999;
}

/* Popup Box */
.popup-box {
  background: #fff;
  width: 90%;
  max-width: 380px;
  padding: 25px;
  border-radius: 12px;
  text-align: center;
  animation: popIn 0.4s ease;
  position: relative;
}

/* Close Button */
.close-popup {
  position: absolute;
  top: 12px;
  right: 15px;
  font-size: 25px;
  cursor: pointer;
}

/* Text */
.popup-title {
  font-weight: 700;
  font-size: 24px;
}

.popup-text {
  margin: 10px 0 20px;
  font-size: 15px;
}

/* Inputs */
.popup-input {
  width: 100%;
  padding: 12px;
  margin-bottom: 12px;
  border-radius: 8px;
  border: 1px solid #ccc;
}

/* Button */
.popup-btn {
  width: 100%;
  padding: 12px;
  background: #000;
  color: #fff;
  border: none;
  border-radius: 8px;
  font-size: 16px;
  cursor: pointer;
}

.popup-btn:hover {
  opacity: 0.9;
}

/* Animation */
@keyframes popIn {
  from {
    opacity: 0;
    transform: scale(0.7);
  }
  to {
    opacity: 1;
    transform: scale(1);
  }
}
</style>

<script>
  // Show popup after 6 seconds
  window.onload = function() {
    setTimeout(() => {
      document.getElementById("subscribePopup").style.display = "flex";
    }, 6000);
  };

  // Close popup
  function closePopup() {
    document.getElementById("subscribePopup").style.display = "none";
  }
</script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
