<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Tbil Properties</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="assets/img/favicon.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="assets/vendor/aos/aos.css" rel="stylesheet">
  <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

  <!-- Main CSS File -->
  <link href="assets/css/main.css" rel="stylesheet">

  <!-- =======================================================
  * Template Name: HomeSpace
  * Template URL: https://bootstrapmade.com/homespace-bootstrap-real-estate-template/
  * Updated: Jul 05 2025 with Bootstrap v5.3.7
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">

  <header id="header" class="header d-flex align-items-center sticky-top">
    <div class="container-fluid container-xl position-relative d-flex align-items-center justify-content-between">

      <a href="index.php" class="logo d-flex align-items-center">
        <!-- Uncomment the line below if you also wish to use an image logo -->
        <!-- <img src="assets/img/logo.webp" alt=""> -->
        <svg class="my-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <g id="bgCarrier" stroke-width="0"></g>
          <g id="tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
          <g id="iconCarrier">
            <path d="M22 22L2 22" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
            <path d="M2 11L6.06296 7.74968M22 11L13.8741 4.49931C12.7784 3.62279 11.2216 3.62279 10.1259 4.49931L9.34398 5.12486" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
            <path d="M15.5 5.5V3.5C15.5 3.22386 15.7239 3 16 3H18.5C18.7761 3 19 3.22386 19 3.5V8.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
            <path d="M4 22V9.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
            <path d="M20 9.5V13.5M20 22V17.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
            <path d="M15 22V17C15 15.5858 15 14.8787 14.5607 14.4393C14.1213 14 13.4142 14 12 14C10.5858 14 9.87868 14 9.43934 14.4393M9 22V17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            <path d="M14 9.5C14 10.6046 13.1046 11.5 12 11.5C10.8954 11.5 10 10.6046 10 9.5C10 8.39543 10.8954 7.5 12 7.5C13.1046 7.5 14 8.39543 14 9.5Z" stroke="currentColor" stroke-width="1.5"></path>
          </g>
        </svg>
       <img src="assets/img/logo.png"alt="logo"width="80px"height="190px">
      </a>

      <nav id="navmenu" class="navmenu">
        <ul>
          <li><a href="index.php" class="active">Home</a></li>
          <li><a href="about.html">About</a></li>
          <li><a href="properties.html">Properties</a></li>
          <li><a href="services.html">Services</a></li>
          <li><a href="contact.html">Contact</a></li>
        </ul>
        <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
      </nav>

    </div>
  </header>

  <main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">About</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="index.php">Home</a></li>
            <li class="current">About</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

<!-- About Section -->
<section id="about" class="about section">

  <div class="container" data-aos="fade-up" data-aos-delay="100">

    <div class="row justify-content-center">
      <div class="col-lg-10">

        <!-- Intro Content -->
        <div class="hero-content text-center" data-aos="zoom-in" data-aos-delay="200">
          <h2>Welcome to Tbil Properties</h2>
          <p class="hero-description">
            At Monosky, we’re redefining property ownership across Nigeria with integrity, innovation, and unmatched service. Since our inception, we've been helping families, investors, and businesses secure properties that truly elevate their lives and goals. Your vision is our mission.
          </p>
        </div>

        <!-- Dual Image Display -->
        <div class="dual-image-layout" data-aos="fade-up" data-aos-delay="300">
          <div class="row g-4 align-items-center">

            <div class="col-lg-6">
              <div class="primary-image-wrap">
                <img src="assets/img/real-estate/property-exterior-4.webp" alt="Monosky Estate View" class="img-fluid">
                <div class="floating-badge" data-aos="zoom-in" data-aos-delay="400">
                  <div class="badge-content">
                    <i class="bi bi-award"></i>
                    <span>Trusted by Hundreds Nationwide</span>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-lg-6">
              <div class="secondary-image-wrap">
                <img src="assets/img/testimonial-1.jpg" alt="Monosky Agent" class="img-fluid">
              </div>
            </div>

          </div>
        </div>

      </div>
    </div>

    <!-- Features Grid -->
    <div class="features-showcase" data-aos="fade-up" data-aos-delay="350">
      <div class="row gy-4">

        <!-- Feature: Residential Sales -->
        <div class="col-lg-3 col-md-6">
          <div class="feature-box" data-aos="flip-up" data-aos-delay="400">
            <div class="feature-icon">
              <i class="bi bi-house-door"></i>
            </div>
            <div class="feature-content">
              <h4>Residential Sales</h4>
              <p>We provide beautiful, affordable homes that are perfect for families and first-time buyers across Nigeria.</p>
            </div>
          </div>
        </div>

        <!-- Feature: Commercial Properties -->
        <div class="col-lg-3 col-md-6">
          <div class="feature-box" data-aos="flip-up" data-aos-delay="450">
            <div class="feature-icon">
              <i class="bi bi-building"></i>
            </div>
            <div class="feature-content">
              <h4>Commercial Properties</h4>
              <p>From offices to retail spaces, we deliver commercial solutions that meet your growth and expansion plans.</p>
            </div>
          </div>
        </div>

        <!-- Feature: Land & Investment Advisory -->
        <div class="col-lg-3 col-md-6">
          <div class="feature-box" data-aos="flip-up" data-aos-delay="500">
            <div class="feature-icon">
              <i class="bi bi-graph-up-arrow"></i>
            </div>
            <div class="feature-content">
              <h4>Land & Investment Advisory</h4>
              <p>Our experts help you choose high-return locations and guide your journey into profitable property ownership.</p>
            </div>
          </div>
        </div>

        <!-- Feature: Documentation & Legal Support -->
        <div class="col-lg-3 col-md-6">
          <div class="feature-box" data-aos="flip-up" data-aos-delay="550">
            <div class="feature-icon">
              <i class="bi bi-shield-check"></i>
            </div>
            <div class="feature-content">
              <h4>Documentation Support</h4>
              <p>We ensure all your transactions are properly documented and legally protected—giving you peace of mind.</p>
            </div>
          </div>
        </div>

      </div>
    </div><!-- End Features Showcase -->

  </div>
</section>




      </div>

    </section><!-- /About Section -->

  </main>

 <footer id="footer" class="footer accent-background">

  <div class="container footer-top">
    <div class="row gy-4">
      <div class="col-lg-5 col-md-12 footer-about">
        <a href="index.php" class="logo d-flex align-items-center">
         <img src="assets/img/logo.png">
        </a>
        <p>At Tbil Properties, we provide trusted property solutions that match your lifestyle and investment goals. Your dream home or commercial property is just a step away with us.</p>
        <div class="social-links d-flex mt-4">
          <a href="#"><i class="bi bi-twitter-x"></i></a>
          <a href="#"><i class="bi bi-facebook"></i></a>
          <a href="#"><i class="bi bi-instagram"></i></a>
          <a href="#"><i class="bi bi-linkedin"></i></a>
        </div>
      </div>

      <div class="col-lg-2 col-6 footer-links">
        <h4>Quick Links</h4>
        <ul>
          <li><a href="#">Home</a></li>
          <li><a href="#">About Us</a></li>
          <li><a href="#">Our Properties</a></li>
          <li><a href="#">Contact</a></li>
          <li><a href="#">Privacy Policy</a></li>
        </ul>
      </div>

      <div class="col-lg-2 col-6 footer-links">
        <h4>Our Services</h4>
        <ul>
          <li><a href="#">Property Sales</a></li>
          <li><a href="#">Property Rentals</a></li>
          <li><a href="#">Real Estate Consulting</a></li>
          <li><a href="#">Land Acquisition</a></li>
          <li><a href="#">Property Management</a></li>
        </ul>
      </div>

      <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
        <h4>Contact Us</h4>
        <p>Suite 204, Emerald Towers</p>
        <p>Victoria Island, Lagos</p>
        <p>Nigeria</p>
        <p class="mt-4"><strong>Phone:</strong> <span>+234 707 829 8571</span></p>
        <p><strong>Email:</strong> <span>info@monoskyrealestate.com</span></p>
      </div>

    </div>
  </div>

  <div class="container copyright text-center mt-4">
    <p>© <span>Copyright</span> <strong class="px-1 sitename">Tbil Properties</strong>. <span>All Rights Reserved.</span></p>
    <div class="credits">
      Designed by <a href="https://bootstrapmade.com/">BootstrapMade</a> | Customized by Monosky Dev Team
    </div>
  </div>

</footer>

<!-- Scroll Top -->
<a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Preloader -->
<div id="preloader"></div>

<!-- Vendor JS Files -->
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>
<script src="assets/vendor/aos/aos.js"></script>
<script src="assets/vendor/purecounter/purecounter_vanilla.js"></script>
<script src="assets/vendor/swiper/swiper-bundle.min.js"></script>

<!-- Main JS File -->
<script src="assets/js/main.js"></script>
